/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import java.util.LinkedList;
import java.util.List;
import javax.mail.Message;

public class EmailDefinitionBuilder {
    private final Issue issue;
    private List<Recipient> recipients = new LinkedList<Recipient>();
    private List<Recipient> copyRecipients = new LinkedList<Recipient>();
    private List<Recipient> bccRecipients = new LinkedList<Recipient>();
    private EmailOptions emailOptions;
    private String emailBody;
    private String emailSubject;
    private ApplicationUser remoteUser;
    private String to;
    private String cc;
    private String bcc;
    private I18nHelper i18n;

    public EmailDefinitionBuilder(Issue issue) {
        this.issue = issue;
    }

    public EmailDefinitionBuilder withRecipient(Recipient recipient, Message.RecipientType recipientType) {
        if (recipient != null) {
            if (recipientType == Message.RecipientType.TO) {
                this.recipients.add(recipient);
            } else if (recipientType == Message.RecipientType.CC) {
                this.copyRecipients.add(recipient);
            } else {
                this.bccRecipients.add(recipient);
            }
        }
        return this;
    }

    public EmailDefinitionBuilder to(String to) {
        this.to = to;
        return this;
    }

    public EmailDefinitionBuilder cc(String cc) {
        this.cc = cc;
        return this;
    }

    public EmailDefinitionBuilder bcc(String bcc) {
        this.bcc = bcc;
        return this;
    }

    public EmailDefinitionBuilder subject(String subject) {
        this.emailSubject = subject;
        return this;
    }

    public EmailDefinitionBuilder body(String body) {
        this.emailBody = body;
        return this;
    }

    public EmailDefinitionBuilder as(ApplicationUser remoteUser) {
        this.remoteUser = remoteUser;
        return this;
    }

    public EmailDefinitionBuilder withOptions(EmailOptions emailOptions) {
        this.emailOptions = emailOptions == null ? new EmailOptions() : emailOptions;
        return this;
    }

    public EmailDefinition build() {
        return new EmailDefinitionImpl(this.issue, this.recipients, this.copyRecipients, this.bccRecipients, this.emailOptions, this.emailBody, this.emailSubject, this.remoteUser, this.to, this.cc, this.bcc, this.i18n, null, EmailSource.API);
    }
}

