/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.event.issue.DefaultIssueEventBundle;
import com.atlassian.jira.event.issue.DelegatingJiraIssueEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.mail.JiraMailThreader;
import com.atlassian.jira.mail.util.MailAttachmentsManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailThreader;
import com.atlassian.velocity.VelocityManager;
import com.metainf.jira.plugin.emailissue.action.BlacklistRecipientFilter;
import com.metainf.jira.plugin.emailissue.action.EmailBuilder;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.ExternalEmailSenderFilter;
import com.metainf.jira.plugin.emailissue.action.InactiveUsersRecipientFilter;
import com.metainf.jira.plugin.emailissue.action.OwnChangesRecipientFilter;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.RecipientFilterChain;
import com.metainf.jira.plugin.emailissue.action.SecuredCommentsRecipientFilter;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.action.WhitelistRecipientFilter;
import com.metainf.jira.plugin.emailissue.attachment.AttachmentContentProviderDirectory;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.converters.ConverterFactory;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskCustomerAndEmailAddressRecipientFilter;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskInternalCommentRecipientFilter;
import com.metainf.jira.plugin.emailissue.desk.ServiceDeskManager;
import com.metainf.jira.plugin.emailissue.entity.AuditLogDao;
import com.metainf.jira.plugin.emailissue.entity.AuditLogEntry;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.entity.Context;
import com.metainf.jira.plugin.emailissue.entity.ContextDao;
import com.metainf.jira.plugin.emailissue.entity.DefaultTemplate;
import com.metainf.jira.plugin.emailissue.entity.Template;
import com.metainf.jira.plugin.emailissue.handler.EmailThisIssueMailHandler;
import com.metainf.jira.plugin.emailissue.handler.RichTextMailUtils;
import com.metainf.jira.plugin.emailissue.mail.SmartEmail;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;
import com.metainf.jira.plugin.emailissue.template.EmailTemplateTheme;
import com.metainf.jira.plugin.emailissue.template.ImageURIResolver;
import com.metainf.jira.plugin.emailissue.template.MailTemplateManager;
import com.metainf.jira.plugin.emailissue.template.RawFieldRendererImpl;
import com.metainf.jira.plugin.emailissue.template.Renderer;
import com.metainf.jira.plugin.emailissue.template.TemplateRenderer;
import com.metainf.jira.plugin.emailissue.util.AnonymousUser;
import com.metainf.jira.plugin.emailissue.util.CollectionUtils;
import com.metainf.jira.plugin.emailissue.util.StringUtil;
import com.metainf.jira.plugin.emailissue.workflow.IssueTransitioner;
import com.metainf.jira.plugin.versionkit.AppVersionManager;
import com.metainf.jira.plugin.versionkit.AppVersionManagerImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;
import org.ofbiz.core.entity.GenericValue;

public class EmailBuilderImpl
implements EmailBuilder {
    private static transient Logger logger = Logger.getLogger(EmailBuilderImpl.class);
    private static final String COMMENT_PERMALINK = "<a href=\"{0}/browse/{1}?focusedCommentId={2}&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-{2}\">[Please click here to read the comment]</a>";
    private UserResolver userResolver;
    private MailTemplateManager mailTemplateManager;
    private CommentManager commentManager;
    private com.atlassian.sal.api.ApplicationProperties applicationProperties;
    private final ApplicationProperties jiraApplicationProperties;
    private RendererManager rendererManager;
    private WatcherManager watcherManager;
    private EventTypeManager eventTypeManager;
    private IssueEventManager issueEventManager;
    private UserPreferencesManager userPreferencesManager;
    private ContextDao contextDao;
    private ConfigurationManager configurationManager;
    private ProjectRoleManager projectRoleManager;
    private GroupManager groupManager;
    private UserManager userManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final TemplateRenderer templateRenderer;
    private final CustomFieldManager customFieldManager;
    private final IssueManager issueManager;
    private AttachmentContentProviderDirectory attachmentContentProviderDirectory;
    private AuditLogDao auditLogDao;
    private final PermissionManager permissionManager;
    private final PermissionChecker permissionChecker;
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext jac;
    private final UserPropertyManager userPropertyManager;
    private final ServiceDeskManager serviceDeskManager;
    private final VelocityManager velocityManager;
    private AppVersionManager appVersionManager;
    private final IssueTransitioner issueTransitioner;

    public EmailBuilderImpl(UserResolver userResolver, CommentManager commentManager, com.atlassian.sal.api.ApplicationProperties applicationProperties, RendererManager rendererManager, WatcherManager watcherManager, EventTypeManager eventTypeManager, IssueEventManager issueEventManager, ContextDao contextDao, ConfigurationManager configurationManager, MailTemplateManager mailTemplateManager, ApplicationProperties jiraApplicationProperties, UserPreferencesManager userPreferencesManager, UserManager userManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, TemplateRenderer templateRenderer, AttachmentContentProviderDirectory attachmentContentProviderDirectory, AuditLogDao auditLogDao, PermissionManager permissionManager, CustomFieldManager customFieldManager, IssueManager issueManager, PermissionChecker permissionChecker, FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext jac, UserPropertyManager userPropertyManager, IssueTransitioner issueTransitioner, ServiceDeskManager serviceDeskManager, VelocityManager velocityManager) {
        this.userResolver = userResolver;
        this.commentManager = commentManager;
        this.applicationProperties = applicationProperties;
        this.rendererManager = rendererManager;
        this.watcherManager = watcherManager;
        this.jiraApplicationProperties = jiraApplicationProperties;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.templateRenderer = templateRenderer;
        this.customFieldManager = customFieldManager;
        this.issueManager = issueManager;
        this.eventTypeManager = eventTypeManager;
        this.issueEventManager = issueEventManager;
        this.contextDao = contextDao;
        this.configurationManager = configurationManager;
        this.mailTemplateManager = mailTemplateManager;
        this.permissionManager = permissionManager;
        this.userPreferencesManager = userPreferencesManager;
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.attachmentContentProviderDirectory = attachmentContentProviderDirectory;
        this.auditLogDao = auditLogDao;
        this.permissionChecker = permissionChecker;
        this.fieldLayoutManager = fieldLayoutManager;
        this.jac = jac;
        this.userPropertyManager = userPropertyManager;
        this.issueTransitioner = issueTransitioner;
        this.velocityManager = velocityManager;
        this.appVersionManager = new AppVersionManagerImpl();
        this.serviceDeskManager = serviceDeskManager;
    }

    @Override
    public void sendEmailWithUserEditedSubject(EmailDefinition def, String emailSubject, ApplicationUser remoteUser) throws Exception {
        logger.info((Object)"Start of sending email");
        if (remoteUser == null) {
            remoteUser = new AnonymousUser();
        }
        Issue issue = def.getIssueObject();
        logger.info((Object)("executing on issue: " + def.getIssueObject().getKey()));
        if (def.getEmailOptions().isRichHtml()) {
            def.getEmailOptions().setEmailFormat("html");
        }
        if (def.isCustomerNotification()) {
            def.getRecipientObjects().add(new Recipient("o:reporter", def.getIssueObject().getReporter().getDisplayName(), Recipient.Type.OTHER_USER));
        }
        RecipientFilterChain recipientFilter = this.createRecipientFilter(def, remoteUser);
        Set<ApplicationUser> recipientUsers = this.userResolver.getAuthorizedUserRecipients(def, def.getRecipientObjects(), def.getEmailIssueTo(), recipientFilter);
        Set<String> recipients = this.userResolver.getAuthorizedNonUserRecipients(def, def.getRecipientObjects(), def.getEmailIssueTo(), recipientFilter);
        this.addEmailAddresses(recipients, recipientUsers);
        Set<ApplicationUser> copyRecipientUsers = this.userResolver.getAuthorizedUserRecipients(def, def.getCopyrecipientObjects(), def.getEmailIssueCc(), recipientFilter);
        Set<String> copyRecipients = this.userResolver.getAuthorizedNonUserRecipients(def, def.getCopyrecipientObjects(), def.getEmailIssueCc(), recipientFilter);
        this.addEmailAddresses(copyRecipients, copyRecipientUsers);
        HashSet<ApplicationUser> blindCopyRecipientUsers = this.configurationManager.getGlobalConfiguration().isBccEnabled() ? this.userResolver.getAuthorizedUserRecipients(def, def.getBlindCopyrecipientObjects(), def.getEmailIssueBcc(), recipientFilter) : new HashSet<ApplicationUser>();
        HashSet<String> blindCopyRecipients = this.configurationManager.getGlobalConfiguration().isBccEnabled() ? this.userResolver.getAuthorizedNonUserRecipients(def, def.getBlindCopyrecipientObjects(), def.getEmailIssueBcc(), recipientFilter) : new HashSet<String>();
        this.addEmailAddresses(blindCopyRecipients, blindCopyRecipientUsers);
        if (recipients.isEmpty() && copyRecipients.isEmpty() && blindCopyRecipients.isEmpty()) {
            return;
        }
        String mailBody = this.isTextEmail(def) ? def.getEmailIssueBody() : this.getRenderedEmailBody(def);
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("htmlComment", mailBody);
        Map contextParams = this.mailTemplateManager.getIssueMailContextParams(issue, remoteUser, def);
        if (def.getVelocityContext() != null) {
            contextParams.putAll(def.getVelocityContext());
        }
        contextParams.put("mailBody", mailBody);
        if (def.getEmailOptions().isRichHtml()) {
            contextParams.put("mailBodyHtml", def.getEmailIssueBody());
        }
        if (def.isCustomerNotification() && def.getCommentObject() != null && this.serviceDeskManager.isInternalComment(def.getCommentObject())) {
            this.replaceInternalCommentInContextWithCustomerMessage(def, contextParams);
        } else if (this.isCommentSecured(def.getCommentObject()) && (def.isHasExternalRecipients() || this.hasUserRecipientsUnauthorizedForComment(def, def.getCommentObject(), recipientUsers, copyRecipientUsers, blindCopyRecipientUsers))) {
            this.replaceCommentInContextWithPlaceholder(def, contextParams);
        }
        Context context = this.mailTemplateManager.resolveContext(def.getIssueObject());
        if (context != null && StringUtils.isNotBlank((String)context.getBccAddress())) {
            blindCopyRecipients.add(context.getBccAddress());
        }
        logger.info((Object)"Start building email");
        SmartEmail email = this.buildEmail(context, def, emailSubject, remoteUser, contextParams, recipients, copyRecipients, blindCopyRecipients);
        logger.info((Object)("Email being sent: " + (Object)((Object)email)));
        JiraMailThreader jiraMailThreader = new JiraMailThreader(def.getIssueObject());
        jiraMailThreader.threadEmail((Email)email);
        String messageId = jiraMailThreader.getCustomMessageId((Email)email);
        email.setMessageId(messageId);
        email.send((MailThreader)jiraMailThreader);
        if (def.getSource() != EmailSource.TEST) {
            logger.info((Object)"Email sent");
            this.createAuditLog(email, def, context, contextParams);
            logger.info((Object)"Audit log created");
            if (context == null || context.isEmailDetailsInComment()) {
                this.addComment(email, def, remoteUser, contextParams);
            } else {
                this.addComment(def, remoteUser);
            }
            logger.info((Object)"Comment added if wanted");
            this.addWatcher(context, def, issue);
            this.addUserRecipients(context);
            this.fireEvent(def, remoteUser);
            logger.info((Object)"Email event fired");
        }
        logger.info((Object)"End of sending email");
    }

    private void addEmailAddresses(Set<String> emailAddresses, Set<ApplicationUser> users) {
        for (ApplicationUser au : users) {
            emailAddresses.add(au.getEmailAddress());
        }
    }

    private boolean hasUserRecipientsUnauthorizedForComment(EmailDefinition def, Comment comment, Set<ApplicationUser> to, Set<ApplicationUser> cc, Set<ApplicationUser> bcc) {
        if (def.getIssueEvent() != null && comment != null && def.getIssueEvent().getEventTypeId() != EventType.ISSUE_COMMENTED_ID && def.getIssueEvent().getEventTypeId() != EventType.ISSUE_COMMENT_EDITED_ID) {
            HashSet<ApplicationUser> recipients = new HashSet<ApplicationUser>();
            if (to != null && !to.isEmpty()) {
                recipients.addAll(to);
            }
            if (cc != null && !cc.isEmpty()) {
                recipients.addAll(cc);
            }
            if (bcc != null && !bcc.isEmpty()) {
                recipients.addAll(bcc);
            }
            for (ApplicationUser au : recipients) {
                if (StringUtils.isNotBlank((String)comment.getGroupLevel()) && this.groupManager.getGroupNamesForUser(au).contains(def.getIssueEvent().getComment().getGroupLevel()) || def.getIssueEvent().getComment().getRoleLevel() != null && this.projectRoleManager.isUserInProjectRole(au, def.getIssueEvent().getComment().getRoleLevel(), def.getIssueObject().getProjectObject())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public SmartEmail buildEmail(EmailDefinition def, String emailSubject, ApplicationUser remoteUser) throws Exception {
        Context context;
        HashSet<String> blindCopyRecipients;
        logger.info((Object)"Start of building email");
        if (remoteUser == null) {
            remoteUser = new AnonymousUser();
        }
        Issue issue = def.getIssueObject();
        logger.info((Object)("executing on issue: " + def.getIssueObject().getKey()));
        if (def.getEmailOptions().isRichHtml()) {
            def.getEmailOptions().setEmailFormat("html");
        }
        RecipientFilterChain recipientFilter = this.createRecipientFilter(def, remoteUser);
        Set<String> recipients = this.userResolver.getAuthorizedRecipients(def, recipientFilter);
        Set<String> copyRecipients = this.userResolver.getAuthorizedCopyRecipients(def, recipientFilter);
        Set<String> set = blindCopyRecipients = this.configurationManager.getGlobalConfiguration().isBccEnabled() ? this.userResolver.getAuthorizedBlindCopyRecipients(def, recipientFilter) : new HashSet<String>();
        if (recipients.isEmpty() && copyRecipients.isEmpty() && blindCopyRecipients.isEmpty()) {
            return null;
        }
        String mailBody = this.isTextEmail(def) ? def.getEmailIssueBody() : this.getRenderedEmailBody(def);
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("htmlComment", mailBody);
        Map contextParams = this.mailTemplateManager.getIssueMailContextParams(issue, remoteUser, def);
        if (def.getVelocityContext() != null) {
            contextParams.putAll(def.getVelocityContext());
        }
        contextParams.put("mailBody", mailBody);
        if (def.getEmailOptions().isRichHtml()) {
            contextParams.put("mailBodyHtml", def.getEmailIssueBody());
        }
        if (this.isCommentSecured(def.getCommentObject()) && def.isHasExternalRecipients()) {
            this.replaceCommentInContextWithPlaceholder(def, contextParams);
        }
        if ((context = this.mailTemplateManager.resolveContext(def.getIssueObject())) != null && StringUtils.isNotBlank((String)context.getBccAddress())) {
            blindCopyRecipients.add(context.getBccAddress());
        }
        logger.info((Object)"Email built");
        SmartEmail email = this.buildEmail(context, def, emailSubject, remoteUser, contextParams, recipients, copyRecipients, blindCopyRecipients);
        return email;
    }

    private void addUserRecipients(Context context) {
    }

    private boolean isCommentSecured(Comment commentObject) {
        return commentObject != null && (commentObject.getRoleLevelId() != null || StringUtils.isNotBlank((String)commentObject.getGroupLevel()));
    }

    private void replaceInternalCommentInContextWithCustomerMessage(EmailDefinition def, Map contextParams) {
        String comment = "The request has been updated. Please open it in the customer portal to see the changes.";
        if (contextParams.containsKey("htmlComment")) {
            contextParams.put("htmlComment", comment);
        }
        if (contextParams.containsKey("comment")) {
            contextParams.put("comment", comment);
        }
    }

    private void replaceCommentInContextWithPlaceholder(EmailDefinition def, Map contextParams) {
        String htmlComment;
        Comment commentObject = def.getCommentObject();
        String comment = htmlComment = "[please log in to read the comment]";
        if (commentObject != null) {
            htmlComment = MessageFormat.format(COMMENT_PERMALINK, this.applicationProperties.getBaseUrl(), def.getIssueObject().getKey(), def.getCommentObject().getId().toString());
            if (this.isHtmlEmail(def) || this.isRichHtmlEmail(def)) {
                comment = htmlComment;
            }
        }
        if (contextParams.containsKey("htmlComment")) {
            contextParams.put("htmlComment", htmlComment);
        }
        if (contextParams.containsKey("comment")) {
            contextParams.put("comment", comment);
        }
    }

    private String getRenderedEmailBody(EmailDefinition def) {
        String rendered = "";
        if (StringUtils.isNotBlank((String)def.getEmailIssueBody())) {
            if (this.isRichHtmlEmail(def)) {
                rendered = def.getEmailIssueBody();
            } else {
                String renderer = this.isTextEmail(def) ? Renderer.TEXT.getKey() : Renderer.WIKI.getKey();
                rendered = this.rendererManager.getRenderedContent(renderer, def.getEmailIssueBody(), def.getIssueObject().getIssueRenderContext());
            }
        }
        return rendered;
    }

    private void createAuditLog(SmartEmail email, EmailDefinition def, Context context, Map contextParams) {
        try {
            EventType eventType;
            Template template = def.getEmailTemplate() == null ? (context == null ? null : context.getTemplate()) : def.getEmailTemplate();
            String attachmentNames = null;
            Attachment[] attachmentObjects = def.getAttachmentObjects();
            if (attachmentObjects != null && attachmentObjects.length > 0) {
                StringBuilder attachments = new StringBuilder();
                for (Attachment a : def.getAttachmentObjects()) {
                    if (attachments.length() > 0) {
                        attachments.append(", ");
                    }
                    attachments.append(a.getFilename());
                }
                attachmentNames = attachments.toString();
            }
            String renderedBody = contextParams.containsKey("rawEmailBody") ? (String)contextParams.get("rawEmailBody") : email.getBody();
            renderedBody = this.isTextEmail(def) ? this.rendererManager.getRenderedContent(Renderer.TEXT.getKey(), renderedBody, def.getIssueObject().getIssueRenderContext()) : RichTextMailUtils.tidyHtml(renderedBody);
            String source = def.getSource().name();
            if (def.getIssueEvent() != null && def.getIssueEvent().getEventTypeId() != null && (eventType = this.eventTypeManager.getEventType(def.getIssueEvent().getEventTypeId())) != null) {
                source = source + ": " + eventType.getName();
            }
            this.auditLogDao.create(def.getRemoteUser(), def.getIssueObject(), email.getSubject(), renderedBody, email.getFrom(), email.getFromName(), email.getTo(), email.getCc(), email.getBcc(), def.getEmailOptions().getEmailFormat(), def.getEmailOptions().isReplyToMe(), def.getEmailOptions().isMailAsMe(), def.getEmailOptions().isAddToWatchers(), attachmentNames, template, source, def.getEmailOptions().isAddComments(), AuditLogEntry.EmailType.OUTGOING);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private RecipientFilterChain createRecipientFilter(EmailDefinition def, ApplicationUser remoteUser) {
        Configuration globalConfig = this.configurationManager.getGlobalConfiguration();
        RecipientFilterChain chain = new RecipientFilterChain();
        chain.next(new InactiveUsersRecipientFilter(globalConfig));
        if (def.isCustomerNotification()) {
            chain.next(new ServiceDeskCustomerAndEmailAddressRecipientFilter(this.serviceDeskManager, this.permissionChecker, def));
            chain.next(new OwnChangesRecipientFilter(def, this.userPreferencesManager, globalConfig));
        } else {
            if (def.getIssueEvent() != null && remoteUser != null && !(remoteUser instanceof AnonymousUser)) {
                chain.next(new OwnChangesRecipientFilter(def, this.userPreferencesManager, globalConfig));
            }
            if (!(def.getIssueEvent() == null || def.getIssueEvent().getEventTypeId() != EventType.ISSUE_COMMENTED_ID && def.getIssueEvent().getEventTypeId() != EventType.ISSUE_COMMENT_EDITED_ID || def.getIssueEvent().getComment() == null || def.getIssueEvent().getComment().getRoleLevel() == null && !StringUtils.isNotBlank((String)def.getIssueEvent().getComment().getGroupLevel()))) {
                chain.next(new SecuredCommentsRecipientFilter(def, this.groupManager, this.projectRoleManager));
            }
        }
        if (StringUtils.isNotBlank((String)this.configurationManager.getGlobalConfiguration().getRecipientWhitelist())) {
            chain.next(new WhitelistRecipientFilter(this.configurationManager.getGlobalConfiguration().getRecipientWhitelist()));
        }
        if (StringUtils.isNotBlank((String)this.configurationManager.getGlobalConfiguration().getRecipientBlacklist())) {
            chain.next(new BlacklistRecipientFilter(this.configurationManager.getGlobalConfiguration().getRecipientBlacklist()));
        }
        if (def.getIssueEvent() != null && EmailThisIssueMailHandler.externalEmailSender.get() != null) {
            chain.next(new ExternalEmailSenderFilter());
        }
        if (!def.isCustomerNotification() && def.getIssueEvent() != null && def.getCommentObject() != null && this.serviceDeskManager.isInternalComment(def.getCommentObject())) {
            chain.next(new ServiceDeskInternalCommentRecipientFilter(this.serviceDeskManager, this.permissionChecker, def.getIssueObject()));
        }
        return chain;
    }

    @Override
    public void sendEmail(EmailDefinition def, ApplicationUser remoteUser) throws Exception {
        this.sendEmailWithUserEditedSubject(def, null, remoteUser);
    }

    private void fireEvent(final EmailDefinition def, final ApplicationUser remoteUser) {
        Long eventId = def.getEventTypeId();
        if (eventId != null && eventId > 0L) {
            try {
                if (remoteUser == null || remoteUser instanceof AnonymousUser) {
                    return;
                }
                final EventType eventType = this.eventTypeManager.getEventType(eventId);
                if (eventType != null) {
                    DefaultIssueEventBundle bundle = DefaultIssueEventBundle.create(Arrays.asList(new DelegatingJiraIssueEvent(){

                        @Nonnull
                        public IssueEvent asIssueEvent() {
                            return new IssueEvent(def.getIssueObject(), new HashMap(), remoteUser, eventType.getId(), true);
                        }
                    }));
                    this.issueEventManager.dispatchEvent((IssueEventBundle)bundle);
                    logger.debug((Object)("Event fired: " + eventId));
                }
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)("Event not fire because event type may not exist: " + eventId));
            }
            catch (Exception e) {
                logger.warn((Object)("Event not fire: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void addWatcher(Context context, EmailDefinition def, Issue issue) {
        if (def.getEmailOptions().isAddToWatchers()) {
            Set<ApplicationUser> users = this.userResolver.getUsers(def);
            try {
                for (ApplicationUser user : users) {
                    logger.info((Object)("User " + user.getDisplayName() + " will start to watch " + issue.getKey()));
                    if (!this.permissionChecker.isAllowedToViewIssue(user, issue)) continue;
                    this.watcherManager.startWatching(user, issue);
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (context != null && context.getExternalWatcherFieldId() != null) {
                    String currentValue;
                    String newValue;
                    CustomField externalWatcherField = this.customFieldManager.getCustomFieldObject(context.getExternalWatcherFieldId());
                    Set<String> emailAddresses = this.userResolver.getExternalRecipients(def);
                    if (emailAddresses.isEmpty() || externalWatcherField == null || this.customFieldManager.getCustomFieldObjects(issue).contains(externalWatcherField)) {
                        // empty if block
                    }
                    if ((newValue = StringUtil.merge(currentValue = (String)issue.getCustomFieldValue(externalWatcherField), emailAddresses, ",")) != null && !newValue.equalsIgnoreCase(currentValue)) {
                        MutableIssue mutableIssue = this.issueManager.getIssueObject(issue.getId());
                        mutableIssue.setCustomFieldValue(externalWatcherField, (Object)newValue.toLowerCase());
                        this.issueManager.updateIssue(def.getRemoteUser(), mutableIssue, EventDispatchOption.DO_NOT_DISPATCH, false);
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void addComment(SmartEmail email, EmailDefinition def, ApplicationUser loggedInUser, Map contextParams) throws VelocityException {
        String visibility = def.getEmailOptions().getCommentVisibility();
        if (!"none".equalsIgnoreCase(visibility) && (def.getSource() == EmailSource.OPERATION || def.getSource() == EmailSource.BULK) && this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, def.getIssueObject(), def.getRemoteUser())) {
            String dateTimeSent = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.COMPLETE).withDefaultLocale().format(new Date());
            contextParams.put("dateTimeSent", dateTimeSent);
            contextParams.put("email", email);
            contextParams.put("emailDef", def);
            FieldLayoutItem fyi = this.fieldLayoutManager.getFieldLayout(def.getIssueObject()).getFieldLayoutItem("comment");
            Renderer renderer = fyi != null ? Renderer.getByKey(fyi.getRendererType()) : Renderer.WIKI;
            String templateContent = this.mailTemplateManager.getCommentTemplateContent(def.getIssueObject(), renderer.getFormat());
            String baseUrl = this.applicationProperties.getBaseUrl();
            String commentBody = this.templateRenderer.renderContent(templateContent, baseUrl, contextParams, renderer == Renderer.JEDITOR || renderer == Renderer.WIKI ? TemplateRenderer.TargetFormat.HTML : TemplateRenderer.TargetFormat.TEXT);
            commentBody = this.convertText(commentBody, def.getEmailOptions().isRichHtml(), fyi);
            String groupLevel = visibility != null && visibility.startsWith("g:") ? visibility.substring(2) : null;
            Long roleLevelId = visibility != null && visibility.startsWith("r:") ? Long.valueOf(Long.parseLong(visibility.substring(2))) : null;
            String authorKey = (loggedInUser == null || loggedInUser instanceof AnonymousUser ? def.getIssueObject().getReporter() : loggedInUser).getKey();
            this.commentManager.create(def.getIssueObject(), this.userManager.getUserByKeyEvenWhenUnknown(authorKey), commentBody, groupLevel, roleLevelId, !def.getEmailOptions().isSuppressCommentEvent());
        }
    }

    protected void addComment(EmailDefinition def, ApplicationUser loggedInUser) throws VelocityException {
        String visibility = def.getEmailOptions().getCommentVisibility();
        if (!"none".equalsIgnoreCase(visibility) && (def.getSource() == EmailSource.OPERATION || def.getSource() == EmailSource.BULK) && StringUtils.isNotBlank((String)def.getEmailIssueBody()) && this.permissionManager.hasPermission(ProjectPermissions.ADD_COMMENTS, def.getIssueObject(), def.getRemoteUser())) {
            String groupLevel = visibility != null && visibility.startsWith("g:") ? visibility.substring(2) : null;
            Long roleLevelId = visibility != null && visibility.startsWith("r:") ? Long.valueOf(Long.parseLong(visibility.substring(2))) : null;
            String authorKey = (loggedInUser == null || loggedInUser instanceof AnonymousUser ? def.getIssueObject().getReporter() : loggedInUser).getKey();
            FieldLayoutItem fyi = this.fieldLayoutManager.getFieldLayout(def.getIssueObject()).getFieldLayoutItem("comment");
            String commentBody = def.getEmailIssueBody();
            commentBody = this.convertText(commentBody, def.getEmailOptions().isRichHtml(), fyi);
            this.commentManager.create(def.getIssueObject(), this.userManager.getUserByKeyEvenWhenUnknown(authorKey), commentBody, groupLevel, roleLevelId, !def.getEmailOptions().isSuppressCommentEvent());
        }
    }

    protected String convertText(String text, boolean isHtml, FieldLayoutItem fyi) {
        String converted = null;
        String renderer = fyi != null ? fyi.getRendererType() : null;
        try {
            converted = isHtml ? (this.isWikiRenderer(renderer) ? ConverterFactory.createHtmlToWikiMarkupConverter(Collections.EMPTY_LIST).convert(text) : (this.isTextRenderer(renderer) ? ConverterFactory.createHtmlToTextConverter().convert(text) : text)) : (this.isWikiRenderer(renderer) ? text : (String)this.rendererManager.getRendererForType(fyi != null ? fyi.getRendererType() : null).transformFromEdit((Object)text));
        }
        catch (IOException e) {
            logger.warn((Object)"Cannot convert content", (Throwable)e);
        }
        return converted;
    }

    protected boolean isWikiRenderer(String rendererType) {
        return Renderer.WIKI.getKey().equalsIgnoreCase(rendererType);
    }

    protected boolean isTextRenderer(String rendererType) {
        return Renderer.TEXT.getKey().equalsIgnoreCase(rendererType);
    }

    protected boolean isJEditorRenderer(String rendererType) {
        return Renderer.JEDITOR.getKey().equalsIgnoreCase(rendererType);
    }

    protected String getCommentRendererType(Issue issue) {
        FieldLayoutItem fyi = this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem("comment");
        return fyi == null ? null : fyi.getRendererType();
    }

    protected SmartEmail buildEmail(Context context, EmailDefinition def, String userEditedEmailSubject, ApplicationUser loggedInUser, Map contextParams, Set<String> recipients, Set<String> copyRecipients, Set<String> blindCopyRecipients) throws VelocityException, MessagingException {
        boolean explicitlyAddedAttachmentsNotAllowed;
        String senderPattern;
        String emailAddress;
        Template template = def.getEmailTemplate();
        if (template == null) {
            template = context != null && context.getTemplate() != null ? context.getTemplate() : DefaultTemplate.fromTheme(EmailTemplateTheme.defaultTheme());
        }
        String bodyTemplate = this.isHtmlEmail(def) ? template.getHtml() : template.getText();
        String baseUrl = this.applicationProperties.getBaseUrl();
        contextParams.put("emailDef", def);
        MailAttachmentsManager mailAttachmentsManager = (MailAttachmentsManager)contextParams.get("attachmentsManager");
        if (mailAttachmentsManager != null) {
            // empty if block
        }
        String body = this.templateRenderer.renderContent(bodyTemplate, baseUrl, contextParams, this.isHtmlEmail(def) || this.isRichHtmlEmail(def) ? TemplateRenderer.TargetFormat.HTML : TemplateRenderer.TargetFormat.TEXT);
        ImageURIResolver resolver = new ImageURIResolver(baseUrl);
        body = resolver.resolve(body);
        String subject = userEditedEmailSubject;
        if (StringUtils.isBlank((String)subject)) {
            String subjectTemplate = template == null ? def.getI18n().getText("issuemail.subject") + " $!mailSubject" : template.getSubject();
            subjectTemplate = StringUtils.isEmpty((String)subjectTemplate) ? "($!issue.key) $!issue.summary $!mailSubject" : subjectTemplate;
            subject = this.templateRenderer.renderTextContent(subjectTemplate, baseUrl, contextParams);
        }
        SmartEmail email = new SmartEmail(CollectionUtils.toString(recipients), CollectionUtils.toString(copyRecipients), CollectionUtils.toString(blindCopyRecipients), this.applicationProperties, this.configurationManager.getGlobalConfiguration());
        String string = emailAddress = loggedInUser != null && !(loggedInUser instanceof AnonymousUser) ? loggedInUser.getEmailAddress() : "";
        String senderName = loggedInUser != null ? (StringUtils.isEmpty((String)loggedInUser.getDisplayName()) ? loggedInUser.getName() : loggedInUser.getDisplayName()) : "";
        String fromName = null;
        String string2 = senderPattern = context == null ? null : context.getSenderTemplate();
        if (StringUtils.isNotBlank((String)senderPattern)) {
            fromName = this.templateRenderer.renderTextContent(senderPattern, baseUrl, contextParams);
        } else {
            fromName = this.jiraApplicationProperties.getString("jira.email.fromheader.format");
            String hostname = emailAddress != null ? emailAddress.substring(emailAddress.indexOf("@") + 1) : "";
            fromName = StringUtils.replace((String)fromName, (String)"${fullname}", (String)senderName);
            fromName = StringUtils.replace((String)fromName, (String)"${email}", (String)emailAddress);
            fromName = StringUtils.replace((String)fromName, (String)"${email.hostname}", (String)hostname);
        }
        String fromAddress = null;
        if (StringUtils.isNotBlank((String)def.getFromAddress())) {
            fromAddress = def.getFromAddress();
        } else {
            String string3 = fromAddress = def.getEmailOptions().isMailAsMe() ? emailAddress : OFBizPropertyUtils.getPropertySet((GenericValue)def.getIssueObject().getProjectObject().getGenericValue()).getString("jira.project.email.sender");
            if (context != null && StringUtils.isNotBlank((String)context.getFromAddress())) {
                HashMap<String, RawFieldRendererImpl> contextForRenderingFromAddress = new HashMap<String, RawFieldRendererImpl>(contextParams);
                contextForRenderingFromAddress.put("jetiFieldRenderer", new RawFieldRendererImpl(this.customFieldManager, this.jac, this.fieldLayoutManager, this.rendererManager, this.userPropertyManager, this.issueTransitioner, this.dateTimeFormatterFactory));
                String fromEmail = this.velocityManager.getEncodedBodyForContent(context.getFromAddress(), baseUrl, contextForRenderingFromAddress);
                String string4 = fromEmail = StringUtils.isNotBlank((String)fromEmail) ? fromEmail.trim() : fromEmail;
                if (StringUtils.isNotBlank((String)fromEmail) && (this.userResolver.isEmailAddress(fromEmail) || this.userResolver.isExtendedEmailAddress(fromEmail))) {
                    fromAddress = fromEmail;
                }
            }
        }
        email.setFrom(fromAddress);
        email.setFromName(fromName);
        if (def.getEmailOptions().isReplyToMe() && loggedInUser != null && StringUtils.isNotEmpty((String)loggedInUser.getEmailAddress())) {
            email.setReplyTo(loggedInUser.getEmailAddress());
        } else {
            String replyTo = fromAddress;
            if (this.userResolver.isExtendedEmailAddress(fromAddress)) {
                replyTo = this.userResolver.getEmailAddressFromExtendedAddress(fromAddress);
            }
            email.setReplyTo(replyTo);
        }
        email.setSubject(subject == null ? "" : subject);
        if (this.isHtmlEmail(def) && bodyTemplate != null && (bodyTemplate.contains("#defaultMailHeader") || bodyTemplate.contains("#genericChangelogMail"))) {
            body = this.inlineStyles(body);
        }
        contextParams.put("rawEmailBody", body);
        email.setMimeType(this.getMimeType(def));
        Attachment[] attachments = def.getAttachmentObjects();
        HashSet<Attachment> attachmentObjects = attachments != null && attachments.length > 0 ? new HashSet<Attachment>(Arrays.asList(attachments)) : new HashSet<Attachment>();
        Configuration globalConfig = this.configurationManager.getGlobalConfiguration();
        boolean bl = globalConfig.getAttachmentPolicy() != null ? !globalConfig.getAttachmentPolicy().isAllowManual() : (explicitlyAddedAttachmentsNotAllowed = Boolean.TRUE.equals(globalConfig.isDisableAttachments()));
        if ((def.getSource() == EmailSource.OPERATION || def.getSource() == EmailSource.BULK) && explicitlyAddedAttachmentsNotAllowed) {
            attachmentObjects.clear();
        }
        if (def.getSource() == EmailSource.PREVIEW) {
            email.setBody(body);
        } else {
            boolean implicitlyAddedAttachmentsAllowed;
            this.inlineImages(mailAttachmentsManager, email, body, resolver);
            Collection<Attachment> issueAttachments = this.getIssueAttachments(def.getIssueObject());
            boolean bl2 = implicitlyAddedAttachmentsAllowed = globalConfig.getAttachmentPolicy() == null || globalConfig.getAttachmentPolicy().isAllowImplicit();
            if (this.isHtmlEmail(def) && issueAttachments != null && !issueAttachments.isEmpty() && implicitlyAddedAttachmentsAllowed) {
                attachmentObjects.addAll(resolver.resolveMissingAttachments(body, issueAttachments));
            }
            logger.info((Object)("Number of attachments being added to the email: " + (attachmentObjects == null ? 0 : attachmentObjects.size())));
            if (!attachmentObjects.isEmpty()) {
                for (Attachment attachment : attachmentObjects) {
                    logger.info((Object)("Attachment being added to email: " + attachment.getFilename()));
                    email.addAttachment(attachment, this.attachmentContentProviderDirectory.getAttachmentContentProvider());
                }
            }
        }
        return email;
    }

    private void inlineImages(MailAttachmentsManager mailAttachmentsManager, SmartEmail email, String body, ImageURIResolver resolver) throws MessagingException {
        try {
            if (mailAttachmentsManager != null) {
                body = mailAttachmentsManager.inlineImages(body);
                email.setBody(body);
                if (mailAttachmentsManager.getAttachmentsCount() > 0) {
                    Multipart multipart = email.getEmailMultipart();
                    for (BodyPart bodyPart : mailAttachmentsManager.buildAttachmentsBodyParts()) {
                        bodyPart.setDisposition("inline");
                        multipart.addBodyPart(bodyPart);
                    }
                }
            } else {
                email.setBody(body);
            }
            Set<String> imageLinks = resolver.resolveImageLinks(body);
            for (String imageLink : imageLinks) {
                DataSource source = resolver.resolveToDataSource(imageLink);
                if (source == null) continue;
                email.attachOrInline(source.getName(), imageLink, source);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    private Collection<Attachment> getIssueAttachments(Issue issueObject) {
        try {
            return issueObject.getAttachments();
        }
        catch (Exception e) {
            return Collections.EMPTY_LIST;
        }
    }

    private String inlineStyles(String body) {
        try {
            Class<?> clz = Class.forName("com.atlassian.jira.mail.BotoCssInliner");
            Object cssInliner = clz.newInstance();
            Method applyStyles = clz.getMethod("applyStyles", String.class);
            String inlinedBody = (String)applyStyles.invoke(cssInliner, body);
            return inlinedBody;
        }
        catch (Exception e) {
            return body;
        }
    }

    protected String getMimeType(EmailDefinition def) {
        return this.isHtmlEmail(def) ? "text/html" : "text/plain";
    }

    protected boolean isRichHtmlEmail(EmailDefinition def) {
        return this.isHtmlEmail(def) && def.getEmailOptions().isRichHtml();
    }

    protected boolean isHtmlEmail(EmailDefinition def) {
        return "html".equalsIgnoreCase(def.getEmailOptions().getEmailFormat());
    }

    protected boolean isTextEmail(EmailDefinition def) {
        return "text".equalsIgnoreCase(def.getEmailOptions().getEmailFormat());
    }
}

