/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.metainf.jira.plugin.emailissue.action.AddAttachmentType;
import com.metainf.jira.plugin.emailissue.action.BulkEmailBean;
import com.metainf.jira.plugin.emailissue.action.BulkEmailSupport;
import com.metainf.jira.plugin.emailissue.action.EmailDefinition;
import com.metainf.jira.plugin.emailissue.action.EmailOptions;
import com.metainf.jira.plugin.emailissue.action.EmailSource;
import com.metainf.jira.plugin.emailissue.action.EmailSupport;
import com.metainf.jira.plugin.emailissue.action.EmailSupportOptionsInitializer;
import com.metainf.jira.plugin.emailissue.action.GlobalConfigHelper;
import com.metainf.jira.plugin.emailissue.action.PopupGroupPickerSupport;
import com.metainf.jira.plugin.emailissue.action.Recipient;
import com.metainf.jira.plugin.emailissue.action.SessionHelper;
import com.metainf.jira.plugin.emailissue.action.UserResolver;
import com.metainf.jira.plugin.emailissue.config.ConfigurationManager;
import com.metainf.jira.plugin.emailissue.entity.Configuration;
import com.metainf.jira.plugin.emailissue.mail.EmailSender;
import com.metainf.jira.plugin.emailissue.operation.PermissionChecker;
import com.metainf.jira.plugin.emailissue.util.Authorizer;
import com.metainf.jira.plugin.emailissue.util.CollectionUtils;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import com.metainf.jira.plugin.emailissue.util.OptionsCookieHelper;
import com.metainf.jira.plugin.emailissue.workflow.EmailDefinitionImpl;
import com.metainf.jira.plugin.versionkit.AppVersionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class BulkEmailThisIssue
extends BulkEmailSupport
implements EmailSupport {
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = Logger.getLogger((String)BulkEmailThisIssue.class.getName());
    private static final int DEFAULT_MAX = 1;
    private static final PagerFilter ALL_ISSUES_PAGER = PagerFilter.getUnlimitedFilter();
    private String emailIssueTo;
    private String emailIssueCc;
    private String emailIssueBcc;
    private String emailIssueSubject;
    private String emailIssueBody;
    private I18nHelper i18n = this.getI18nHelper();
    private UserResolver userResolver;
    private EmailSender emailSender;
    private String[] recipients;
    private Map<String, Recipient> recipientIndex = new HashMap<String, Recipient>();
    private String[] copyrecipients;
    private Map<String, Recipient> copyrecipientIndex = new HashMap<String, Recipient>();
    private String[] blindcopyrecipients;
    private Map<String, Recipient> blindcopyrecipientIndex = new HashMap<String, Recipient>();
    private EmailOptions emailOptions = new EmailOptions("");
    private String addAttachments;
    private int bulkMax;
    private boolean jeditorEnabled;
    private Authorizer authorizer;
    private PermissionChecker permissionChecker;
    private IssueManager issueManager;
    private SearchProvider searchProvider;
    private GlobalPermissionManager globalPermissionManager;
    private ProjectRoleManager projectRoleManager;
    private GroupManager groupManager;
    private CustomFieldManager customFieldManager;
    private ConfigurationManager configurationManager;
    private AppVersionManager appVersionManager;
    private final PermissionManager permissionManager;

    public BulkEmailThisIssue(UserResolver userResolver, EmailSender emailSender, CustomFieldManager customFieldManager, GroupManager groupManager, ProjectRoleManager projectRoleManager, SearchService searchService, SearchProvider searchProvider, IssueManager issueManager, ApplicationProperties applicationProperties, Authorizer authorizer, PermissionChecker permissionChecker, GlobalPermissionManager globalPermissionManager, ConfigurationManager configurationManager, AppVersionManager appVersionManager, PermissionManager permissionManager, ColumnLayoutManager columnLayoutManager) {
        super(searchService, searchProvider, issueManager, applicationProperties, columnLayoutManager);
        this.configurationManager = configurationManager;
        this.authorizer = authorizer;
        this.userResolver = userResolver;
        this.emailSender = emailSender;
        this.projectRoleManager = projectRoleManager;
        this.customFieldManager = customFieldManager;
        this.permissionManager = permissionManager;
        this.groupManager = groupManager;
        this.permissionChecker = permissionChecker;
        this.issueManager = issueManager;
        this.searchProvider = searchProvider;
        this.globalPermissionManager = globalPermissionManager;
        this.appVersionManager = appVersionManager;
        this.bulkMax = 1;
        String configuredMax = applicationProperties.getDefaultBackedString("jira.bulk.edit.limit.issue.count");
        if (StringUtils.isNotEmpty((String)configuredMax)) {
            try {
                this.bulkMax = Integer.parseInt(configuredMax);
                if (this.bulkMax < 0) {
                    this.bulkMax = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public final String execute() throws Exception {
        String result = super.execute();
        return "input".equalsIgnoreCase(result) && !this.appVersionManager.isBeforeJira6() ? "input6" : result;
    }

    @Override
    public String doDefault() throws Exception {
        if (!this.authorizer.authorize().isValid()) {
            logger.warn((Object)"EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            return this.getRedirect("IssueNavigator.jspa");
        }
        if (this.getSearchRequest() == null) {
            return this.getRedirect("IssueNavigator.jspa");
        }
        if ("true".equals(this.getReset())) {
            this.initialiseBulkEmailBean();
        }
        String result = "input";
        BulkEmailBean beb = (BulkEmailBean)this.getBulkEditBean();
        if (beb != null) {
            beb.setCurrentStep(0);
            ArrayList<Issue> issues = beb.getIssuesFromSearchRequest();
            issues = new ArrayList<Issue>(issues.subList(0, Math.min(issues.size(), this.bulkMax)));
            beb.setIssueListTruncated(issues.size() > this.bulkMax);
            this.filterIssuesForPermissionToSendEmail(issues);
            beb.setIssuesFromSearchRequest(issues);
        }
        return result;
    }

    private void filterIssuesForPermissionToSendEmail(List<Issue> issues) {
        ApplicationUser user = this.getLoggedInUser();
        Iterator<Issue> it = issues.iterator();
        while (it.hasNext()) {
            if (this.permissionChecker.isAllowedToSendIssueInEmail(user, it.next())) continue;
            it.remove();
        }
    }

    public String doCompose() throws Exception {
        if (!this.authorizer.authorize().isValid()) {
            logger.warn((Object)"EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            return this.getRedirect("IssueNavigator.jspa");
        }
        if (this.getSearchRequest() == null) {
            ActionContext.getSession().put("jira.session.timeout.message", this.getText("bulk.edit.session.timeout.message"));
            return this.getRedirect("SessionTimeoutMessage.jspa");
        }
        this.getBulkEditBean().setParams(ActionContext.getParameters());
        if (this.getBulkEditBean().getSelectedIssues().isEmpty()) {
            this.addErrorMessage(this.getText("bulk.email.no.issues"));
        }
        if (this.getBulkEditBean().getSelectedIssues().size() > this.bulkMax) {
            this.addErrorMessage(this.getText("bulk.email.too.many.issues", this.bulkMax));
        }
        if (this.getErrorMessages() == null || this.getErrorMessages().isEmpty()) {
            this.getBulkEditBean().setCurrentStep(1);
        }
        Map<String, String> properties = this.configurationManager.getGlobalConfiguration().isUserOptionsDisabled() ? Collections.EMPTY_MAP : new OptionsCookieHelper().get(ServletActionContext.getRequest());
        EmailSupportOptionsInitializer.initalizeEmailOptions(this, properties, this.configurationManager.getGlobalConfiguration());
        return "input";
    }

    public String doConfirmation() throws Exception {
        if (!this.authorizer.authorize().isValid()) {
            logger.warn((Object)"EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            return this.getRedirect("IssueNavigator.jspa");
        }
        if (this.getSearchRequest() == null) {
            ActionContext.getSession().put("jira.session.timeout.message", this.getText("bulk.edit.session.timeout.message"));
            return this.getRedirect("SessionTimeoutMessage.jspa");
        }
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart("bulk.edit.session.timeout.message");
        }
        logger.debug((Object)"Doing validation...");
        if (StringUtils.isEmpty((String)this.emailIssueTo) && this.recipientIndex.isEmpty() && StringUtils.isEmpty((String)this.emailIssueCc) && this.copyrecipientIndex.isEmpty() && StringUtils.isEmpty((String)this.emailIssueBcc) && this.blindcopyrecipientIndex.isEmpty()) {
            this.addErrorMessage(this.getI18n().getText("issuemail.error.no.recipients"));
        } else {
            Set<String> externalRecipients;
            Set<String> unresolveables = this.userResolver.getUnresolvables(this.emailIssueTo);
            unresolveables.addAll(this.userResolver.getUnresolvables(this.emailIssueCc));
            unresolveables.addAll(this.userResolver.getUnresolvables(this.emailIssueBcc));
            if (!this.configurationManager.getGlobalConfiguration().isPopupGroupPicker() && !unresolveables.isEmpty()) {
                this.addErrorMessage(this.getI18n().getText("issuemail.error.unresolveable.recipients", StringEscapeUtils.escapeHtml((String)CollectionUtils.toString(unresolveables))));
            } else if (!(this.configurationManager.getGlobalConfiguration().getExternalRecipients() != 1 && this.configurationManager.getGlobalConfiguration().getProjectUserRecipients() != 1 || (externalRecipients = this.userResolver.getExternalRecipients(null, this.emailIssueTo, this.emailIssueCc, this.emailIssueBcc, this.getRecipientObjects(), this.getCopyrecipientObjects(), this.getBlindCopyrecipientObjects())).isEmpty())) {
                this.addErrorMessage(this.getI18n().getText("issuemail.error.external.recipients", externalRecipients.toString()));
            }
        }
        if (this.getErrorMessages() == null || this.getErrorMessages().isEmpty()) {
            this.getBulkEditBean().setCurrentStep(2);
            if (this.configurationManager.getGlobalConfiguration().isUserOptionsDisabled()) {
                EmailSupportOptionsInitializer.initalizeEmailOptions(this, Collections.EMPTY_MAP, this.configurationManager.getGlobalConfiguration());
            }
            this.buildEmailActions();
        }
        return "input";
    }

    @Override
    protected void doValidation() {
    }

    @Override
    protected String doExecute() throws Exception {
        if (!this.authorizer.authorize().isValid()) {
            logger.warn((Object)"EmailThisIssue licence is invalid. Contact us at info@meta-inf.hu.");
            return this.getRedirect("IssueNavigator.jspa");
        }
        if (this.getSearchRequest() == null) {
            ActionContext.getSession().put("jira.session.timeout.message", this.getText("bulk.edit.session.timeout.message"));
            return this.getRedirect("SessionTimeoutMessage.jspa");
        }
        this.doSendEmails();
        this.clearBulkEditBean();
        return this.getRedirect("IssueNavigator.jspa");
    }

    private void buildEmailActions() {
        BulkEmailBean beb = (BulkEmailBean)this.getBulkEditBean();
        ArrayList<EmailDefinition> actions2 = new ArrayList<EmailDefinition>(beb.getSelectedIssues().size());
        this.emailOptions.setRichHtml(this.isJeditorEnabled());
        for (Issue issue : beb.getSelectedIssues()) {
            EmailDefinition def = this.buildEmailDefinition(issue);
            actions2.add(def);
        }
        beb.setEmailActions(actions2);
    }

    private void doSendEmails() {
        for (EmailDefinition def : ((BulkEmailBean)this.getBulkEditBean()).getEmailActions()) {
            try {
                this.emailSender.sendEmailAsync(def, this.getLoggedInUser());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private EmailDefinition buildEmailDefinition(Issue issue) {
        AddAttachmentType aat;
        EmailDefinitionImpl def = new EmailDefinitionImpl(issue, this.getRecipientObjects(), this.getCopyrecipientObjects(), this.getBlindCopyrecipientObjects(), this.emailOptions, this.emailIssueBody, this.emailIssueSubject, this.getLoggedInUser(), this.emailIssueTo, this.emailIssueCc, this.emailIssueBcc, this.getI18n(), this.configurationManager.getGlobalConfiguration().getEventId(), EmailSource.BULK);
        if (this.configurationManager.getGlobalConfiguration().isPopupGroupPicker()) {
            def = new PopupGroupPickerSupport(this.userResolver, def);
        }
        if ((aat = AddAttachmentType.getByName(this.addAttachments)) != null) {
            def.setAttachmentObjects(aat.filterAttachments(issue, null).toArray(new Attachment[0]));
        }
        return def;
    }

    public int getCurrentStep() {
        return this.getBulkEditBean().getCurrentStep();
    }

    @Override
    public I18nHelper getI18n() {
        return this.i18n;
    }

    public void setI18n(I18nHelper i18n) {
        this.i18n = i18n;
    }

    public String getIssueTableHtml(boolean allIssues) {
        List issues = allIssues ? this.getBulkEditBean().getIssuesFromSearchRequest() : this.getBulkEditBean().getSelectedIssues();
        try {
            return new IssueTableWebComponent().getHtml(this.getIssueTableLayoutBean(), issues, null);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public List getColumns() throws Exception {
        List columns = super.getColumns();
        if (this.getCurrentStep() == 2 && columns.size() > 1) {
            columns.remove(0);
        }
        return columns;
    }

    public int getSelectedIssuesCount() {
        return this.getBulkEditBean().getSelectedIssues().size();
    }

    @Override
    protected void clearBulkEditBean() {
        SessionHelper.removeJetiBulkEmailBean();
    }

    @Override
    public BulkEditBean getBulkEditBean() {
        return SessionHelper.getJetiBulkEmailBean();
    }

    @Override
    public BulkEditBean getRootBulkEditBean() {
        return SessionHelper.getJetiBulkEmailBean();
    }

    private void initialiseBulkEmailBean() throws SearchException {
        PagerFilter pager;
        BulkEmailBean BulkEmailBean2 = new BulkEmailBean(this.issueManager);
        if (this.bulkMax > -1) {
            int max = (int)Math.min(Integer.MAX_VALUE, (long)this.bulkMax);
            pager = new PagerFilter(max);
            BulkEmailBean2.setMaxIssues(max);
        } else {
            pager = (PagerFilter)this.getSessionPagerFilterManager().getCurrentObject();
            if (pager == null) {
                pager = ALL_ISSUES_PAGER;
            }
        }
        List issues = this.searchProvider.search(this.getSearchRequest() != null ? this.getSearchRequest().getQuery() : null, this.getLoggedInUser(), pager).getIssues();
        BulkEmailBean2.setIssuesFromSearchRequest(issues);
        SessionHelper.storeJetiBulkEmailBean(BulkEmailBean2);
    }

    @Override
    public boolean isHasBrowseUserPermission() {
        return this.getLoggedInUser() != null && this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, this.getLoggedInUser());
    }

    @Override
    public Collection<ProjectRole> getProjectRoles() {
        ArrayList<ProjectRole> roles = new ArrayList<ProjectRole>(this.projectRoleManager.getProjectRoles());
        GlobalConfigHelper.excludeRoles(this.configurationManager.getGlobalConfiguration(), roles);
        return roles;
    }

    @Override
    public Collection<Group> getGroups() {
        ArrayList<Group> groups = new ArrayList<Group>(this.userResolver.getAllUserGroups());
        GlobalConfigHelper.excludeGroups(this.configurationManager.getGlobalConfiguration(), groups);
        return groups;
    }

    @Override
    public List<CustomField> getCustomFields() {
        try {
            List<CustomField> fields = CustomFieldUtil.filterFields(this.configurationManager.getGlobalConfiguration(), new ArrayList<CustomField>(this.customFieldManager.getCustomFieldObjects()));
            return fields;
        }
        catch (IssuePermissionException e) {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public Collection<ProjectRole> getUserRoles() {
        return this.projectRoleManager.getProjectRoles();
    }

    @Override
    public boolean isCommentVisibilityGroups() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.comment.level.visibility.groups");
    }

    @Override
    public Collection<String> getUserGroups() {
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        if (user == null) {
            return Collections.EMPTY_LIST;
        }
        return this.groupManager.getGroupNamesForUser(user);
    }

    @Override
    public String getEmailIssueTo() {
        return this.emailIssueTo;
    }

    @Override
    public void setEmailIssueTo(String emailIssueTo) {
        this.emailIssueTo = emailIssueTo;
    }

    @Override
    public String getEmailIssueBcc() {
        return this.emailIssueBcc;
    }

    @Override
    public void setEmailIssueBcc(String emailIssueBcc) {
        this.emailIssueBcc = emailIssueBcc;
    }

    @Override
    public String getEmailIssueCc() {
        return this.emailIssueCc;
    }

    @Override
    public void setEmailIssueCc(String emailIssueCc) {
        this.emailIssueCc = emailIssueCc;
    }

    @Override
    public String getEmailIssueSubject() {
        return this.emailIssueSubject;
    }

    @Override
    public void setEmailIssueSubject(String emailIssueSubject) {
        this.emailIssueSubject = emailIssueSubject;
    }

    @Override
    public String getEmailIssueBody() {
        return this.emailIssueBody;
    }

    @Override
    public void setEmailIssueBody(String emailIssueBody) {
        this.emailIssueBody = emailIssueBody;
    }

    @Override
    public String[] getRecipients() {
        return this.recipients;
    }

    @Override
    public void setRecipients(String[] recipients) {
        this.recipients = recipients;
        this.recipientIndex = this.buildRecipients(recipients);
    }

    @Override
    public String getOptions() {
        return this.emailOptions.toString();
    }

    @Override
    public void setOptions(String options) {
        this.emailOptions = new EmailOptions(options);
    }

    @Override
    public String[] getCopyrecipients() {
        return this.copyrecipients;
    }

    @Override
    public void setCopyrecipients(String[] copyrecipients) {
        this.copyrecipients = copyrecipients;
        this.copyrecipientIndex = this.buildRecipients(copyrecipients);
    }

    @Override
    public String[] getBlindcopyrecipients() {
        return this.blindcopyrecipients;
    }

    @Override
    public void setBlindcopyrecipients(String[] blindcopyrecipients) {
        this.blindcopyrecipients = blindcopyrecipients;
        this.blindcopyrecipientIndex = this.buildRecipients(blindcopyrecipients);
    }

    @Override
    public boolean isBypassCommentAllowed() {
        return this.configurationManager.getGlobalConfiguration().getBypassComment() == 1;
    }

    @Override
    public String getAddAttachments() {
        return this.addAttachments;
    }

    public void setAddAttachments(String addAttachments) {
        this.addAttachments = addAttachments;
    }

    @Override
    public boolean isRecipientSelected(String key) {
        return this.recipientIndex.containsKey(key);
    }

    @Override
    public boolean isCopyRecipientSelected(String key) {
        return this.copyrecipientIndex.containsKey(key);
    }

    public boolean isBlindCopyRecipientSelected(String key) {
        return this.blindcopyrecipientIndex.containsKey(key);
    }

    public Map<String, Recipient> buildRecipients(String[] recipientKeys) {
        return Recipient.buildRecipients(recipientKeys, this.customFieldManager, this.groupManager, this.projectRoleManager, this.i18n);
    }

    public List<Recipient> getRecipientObjects() {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>(this.recipientIndex.values());
        Collections.sort(recipients);
        return recipients;
    }

    public List<Recipient> getCopyrecipientObjects() {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>(this.copyrecipientIndex.values());
        Collections.sort(recipients);
        return recipients;
    }

    public List<Recipient> getBlindCopyrecipientObjects() {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>(this.blindcopyrecipientIndex.values());
        Collections.sort(recipients);
        return recipients;
    }

    public boolean isBccEnabled() {
        return this.configurationManager.getGlobalConfiguration().isBccEnabled();
    }

    public boolean isUserOptionsEnabled() {
        return !this.configurationManager.getGlobalConfiguration().isUserOptionsDisabled();
    }

    public boolean isAddToWatchers() {
        return this.emailOptions.isAddToWatchers();
    }

    public void setAddToWatchers(boolean addToWatchers) {
        this.emailOptions.setAddToWatchers(addToWatchers);
    }

    public boolean isReplyToMe() {
        return this.emailOptions.isReplyToMe();
    }

    public void setReplyToMe(boolean replyToMe) {
        this.emailOptions.setReplyToMe(replyToMe);
    }

    public boolean isMailAsMe() {
        return this.emailOptions.isMailAsMe();
    }

    public void setMailAsMe(boolean mailAsMe) {
        this.emailOptions.setMailAsMe(mailAsMe);
    }

    public boolean isAddComments() {
        return this.emailOptions.isAddComments();
    }

    public void setAddComments(boolean addComments) {
        this.emailOptions.setAddComments(addComments);
    }

    public boolean isSuppressCommentEvent() {
        return this.emailOptions.isSuppressCommentEvent();
    }

    public void setSuppressCommentEvent(boolean suppressCommentEvent) {
        this.emailOptions.setSuppressCommentEvent(suppressCommentEvent);
    }

    public String getEmailFormat() {
        return this.emailOptions.getEmailFormat();
    }

    public void setEmailFormat(String emailFormat) {
        this.emailOptions.setEmailFormat(emailFormat);
    }

    public String getCommentVisibility() {
        return this.emailOptions.getCommentVisibility();
    }

    public void setCommentVisibility(String commentVisibility) {
        this.emailOptions.setCommentVisibility(commentVisibility);
    }

    public boolean isBypassComment() {
        return this.emailOptions.isBypassComment();
    }

    public void setBypassComment(boolean bypassComment) {
        this.emailOptions.setBypassComment(bypassComment);
    }

    @Override
    public boolean isCommentVisibilitySelected(String cv) {
        return this.getCommentVisibility() != null && this.getCommentVisibility().equals(cv);
    }

    public Configuration getGlobalProperties() {
        return this.configurationManager.getGlobalConfiguration();
    }

    public boolean isJeditorEnabled() {
        return this.jeditorEnabled;
    }

    public void setJeditorEnabled(boolean jeditorEnabled) {
        this.jeditorEnabled = jeditorEnabled;
    }
}

