/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class BulkEmailSupport
extends IssueActionSupport {
    private String reset;
    private long tempMax = -1L;
    private static final PagerFilter ALL_ISSUES_PAGER = PagerFilter.getUnlimitedFilter();
    private final SearchService searchService;
    private final SearchProvider searchProvider;
    private final IssueManager issueManager;
    private ApplicationProperties applicationProperties;
    private final ColumnLayoutManager columnLayoutManager;

    public BulkEmailSupport(SearchService searchService, SearchProvider searchProvider, IssueManager issueManager, ApplicationProperties applicationProperties, ColumnLayoutManager columnLayoutManager) {
        this.searchService = searchService;
        this.searchProvider = searchProvider;
        this.issueManager = issueManager;
        this.applicationProperties = applicationProperties;
        this.columnLayoutManager = columnLayoutManager;
    }

    public String doDefault() throws Exception {
        if (this.getSearchRequest() == null) {
            return this.getRedirect("IssueNavigator.jspa");
        }
        if (this.isNewBulkEdit()) {
            this.initialiseBulkEditBean();
        }
        return super.doDefault();
    }

    private void initialiseBulkEditBean() throws SearchException {
        PagerFilter pager;
        BulkEditBeanImpl bulkEditBean = new BulkEditBeanImpl(this.issueManager);
        bulkEditBean.setIssuesInUse((Collection)bulkEditBean.getIssuesFromSearchRequest());
        if (this.getTempMax() > -1L) {
            int max = (int)Math.min(Integer.MAX_VALUE, this.getTempMax());
            pager = new PagerFilter(max);
            bulkEditBean.setMaxIssues(max);
        } else {
            pager = (PagerFilter)this.getSessionPagerFilterManager().getCurrentObject();
            if (pager == null) {
                pager = ALL_ISSUES_PAGER;
            }
        }
        List issues = this.searchProvider.search(this.getSearchRequest() != null ? this.getSearchRequest().getQuery() : null, this.getLoggedInUser(), pager).getIssues();
        bulkEditBean.setIssuesFromSearchRequest(issues);
        this.storeToSession((BulkEditBean)bulkEditBean);
    }

    private void storeToSession(BulkEditBean bulkEditBean) {
        ActionContext.getSession().put("jira.bulkeditbean", bulkEditBean);
    }

    protected void doValidation() {
        if (this.getSearchRequest() != null) {
            try {
                this.initialiseBulkEditBean();
            }
            catch (SearchException e) {
                this.log.error((Object)"Error occurred while initialising BulkEditBean.", (Throwable)e);
                this.addErrorMessage(this.getText("bulk.bean.initialise.error"));
            }
            this.getBulkEditBean().setParams(ActionContext.getParameters());
            List selectedIssues = this.getBulkEditBean().getSelectedIssues();
            if (selectedIssues.isEmpty()) {
                this.addErrorMessage(this.getText("bulk.edit.you.must.select.at.least.one.issue"));
            } else {
                String maxIssuesString = this.getApplicationProperties().getDefaultBackedString("jira.bulk.edit.limit.issue.count");
                if (StringUtils.isNotEmpty((String)maxIssuesString)) {
                    try {
                        int maxIssues = Integer.parseInt(maxIssuesString);
                        if (maxIssues >= 0 && selectedIssues.size() > maxIssues) {
                            this.addErrorMessage(this.getText("bulk.edit.limit.issue.count.error", Integer.toString(maxIssues)));
                        }
                    }
                    catch (NumberFormatException e) {
                        this.log.error((Object)("Error parsing property 'jira.bulk.edit.limit.issue.count' = '" + maxIssuesString + "' as it is not a number. Ignoring property."), (Throwable)e);
                    }
                }
            }
        }
    }

    private SimpleColumnLayoutItem getCheckboxColumn() {
        return new SimpleColumnLayoutItem(){

            public String getHtml(Map displayParams, Issue issue) {
                String name = BulkEmailSupport.this.getBulkEditBean().getCheckboxName(issue);
                String checked = BulkEmailSupport.this.getBulkEditBean().isChecked(issue) ? "checked" : "";
                return String.format("<input type=\"checkbox\" name=\"%s\" %s />", name, checked);
            }

            public String getHeaderHtml() {
                return "<input type='checkbox' id='bulkedit-select-all' name='all' value='on'>";
            }
        };
    }

    protected String doExecute() throws Exception {
        if (this.getSearchRequest() == null) {
            return this.redirectToSessionTimeout();
        }
        this.getBulkEditBean().setCurrentStep(2);
        return this.getRedirect("BulkChooseOperation!default.jspa");
    }

    public String getCheckboxName(GenericValue issue) {
        return "bulkedit_" + issue.getLong("id");
    }

    public String getReset() {
        return this.reset;
    }

    public void setReset(String reset) {
        this.reset = reset;
    }

    private boolean isNewBulkEdit() {
        return "true".equals(this.getReset());
    }

    public void setCurrentStep(int step) {
        this.getBulkEditBean().setCurrentStep(step);
    }

    public long getTempMax() {
        return this.tempMax;
    }

    public void setTempMax(long tempMax) {
        this.tempMax = tempMax;
    }

    public boolean isBulkLimited() {
        String maxBulkEdit = this.applicationProperties.getDefaultBackedString("jira.bulk.edit.limit.issue.count");
        if (maxBulkEdit != null) {
            try {
                int configuredMax = Integer.parseInt(maxBulkEdit);
                return this.tempMax == (long)configuredMax;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private String redirectToSessionTimeout() {
        ActionContext.getSession().put("jira.session.timeout.message", this.getText("bulk.edit.session.timeout.message"));
        return this.getRedirect("SessionTimeoutMessage.jspa");
    }

    public BulkEditBean getBulkEditBean() {
        return this.getRootBulkEditBean();
    }

    public List getColumns() throws Exception {
        SearchRequest searchRequest = this.getSearchRequest();
        ColumnLayout columnLayout = searchRequest != null && searchRequest.isLoaded() && searchRequest.useColumns() ? this.columnLayoutManager.getColumnLayout(this.getLoggedInUser(), searchRequest) : this.columnLayoutManager.getColumnLayout(this.getLoggedInUser());
        Query query = searchRequest.getQuery();
        QueryContext queryContext = this.searchService.getQueryContext(this.getLoggedInUser(), query);
        List columns = columnLayout.getVisibleColumnLayoutItems(this.getLoggedInUser(), queryContext);
        columns.add(0, this.getCheckboxColumn());
        return columns;
    }

    public IssueTableLayoutBean getIssueTableLayoutBean() throws Exception {
        IssueTableLayoutBean layoutBean = new IssueTableLayoutBean(this.getColumns());
        layoutBean.setSortingEnabled(false);
        return layoutBean;
    }

    protected void clearBulkEditBean() {
        ActionContext.getSession().remove("jira.bulkeditbean");
    }

    protected String finishWizard() throws Exception {
        this.clearBulkEditBean();
        return this.getRedirect("/secure/IssueNavigator.jspa");
    }

    public BulkEditBean getRootBulkEditBean() {
        BulkEditBean bean = (BulkEditBean)ActionContext.getSession().get("jira.bulkeditbean");
        if (bean == null) {
            this.log.warn((Object)"Bulk edit bean unexpectedly null. Perhaps session was lost (e.g. when URL used is different to base URL in General Configuration)?");
        }
        return bean;
    }

    public boolean isCanDisableMailNotifications() {
        if (this.hasGlobalPermission(GlobalPermissionKey.ADMINISTER)) {
            return true;
        }
        Collection projects = this.getBulkEditBean().getProjectObjects();
        for (Project project : projects) {
            if (this.hasProjectPermission(ProjectPermissions.ADMINISTER_PROJECTS, project)) continue;
            return false;
        }
        return true;
    }

    public boolean isSendBulkNotification() {
        return this.getBulkEditBean().isSendBulkNotification();
    }

    public void setSendBulkNotification(boolean sendBulkNotification) {
        if (this.getBulkEditBean() != null) {
            this.getBulkEditBean().setSendBulkNotification(sendBulkNotification);
        }
    }

    protected String redirectToStart(String i18nMessage) {
        ActionContext.getSession().put("jira.session.timeout.message", this.getText(i18nMessage));
        return this.getRedirect("SessionTimeoutMessage.jspa");
    }
}

