/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.attachment.Attachment;
import com.metainf.jira.plugin.emailissue.action.AttachmentComparator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class AttachmentInfo {
    private static final String TITLE = "{0} (uploaded: {1} by {2})";
    private Long id;
    private String filename;
    private String title;
    private boolean thumbnailable;
    private String name;

    public AttachmentInfo(Long id, String filename, String author, String created, boolean addTimestamp, boolean thumbnailable, String name) {
        this.title = MessageFormat.format(TITLE, filename, created, author);
        this.id = id;
        this.filename = filename + (addTimestamp ? " (" + created + ")" : "");
        this.thumbnailable = thumbnailable;
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public Long getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isThumbnailable() {
        return this.thumbnailable;
    }

    public String getName() {
        return this.name;
    }

    public static Collection<AttachmentInfo> fromAttachments(Collection<Attachment> issueAttachments, DateTimeFormatter dateTimeFormatter) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>(issueAttachments);
        Collections.sort(attachments, new AttachmentComparator());
        HashSet<String> names = new HashSet<String>();
        HashSet<String> duplicateNames = new HashSet<String>();
        for (Attachment att : attachments) {
            if (names.contains(att.getFilename())) {
                duplicateNames.add(att.getFilename());
                continue;
            }
            names.add(att.getFilename());
        }
        ArrayList<AttachmentInfo> attachmentInfo = new ArrayList<AttachmentInfo>();
        for (Attachment att : attachments) {
            String displayName = StringUtils.isNotBlank((String)att.getFilename()) && att.getFilename().length() > 60 ? att.getFilename().substring(0, 60) + "..." : att.getFilename();
            String timeStamp = att.getCreated() == null ? "" : dateTimeFormatter.format((Date)att.getCreated());
            String author = att.getAuthorObject() != null ? att.getAuthorObject().getDisplayName() : "unknown";
            attachmentInfo.add(new AttachmentInfo(att.getId(), displayName, author, timeStamp, duplicateNames.contains(att.getFilename()), Boolean.TRUE.equals(att.isThumbnailable()), att.getFilename()));
        }
        return attachmentInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentInfo that = (AttachmentInfo)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

