/*
 * Decompiled with CFR 0.152.
 */
package com.metainf.jira.plugin.emailissue.action;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.CustomField;
import com.metainf.jira.plugin.emailissue.customfield.AttachmentSelectorFieldType;
import com.metainf.jira.plugin.emailissue.util.CustomFieldUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public enum AddAttachmentType {
    ALL{

        @Override
        public List<Attachment> filterAttachments(Issue issue, Set<Long> attachmentIds) {
            Collection issueAttachments = issue != null ? issue.getAttachments() : Collections.EMPTY_LIST;
            return new ArrayList<Attachment>(issueAttachments);
        }
    }
    ,
    NONE{

        @Override
        public List<Attachment> filterAttachments(Issue issue, Set<Long> attachmentIds) {
            return Collections.EMPTY_LIST;
        }
    }
    ,
    OPERATION{

        @Override
        public List<Attachment> filterAttachments(Issue issue, Set<Long> attachmentIds) {
            Collection issueAttachments;
            Collection collection = issueAttachments = issue != null ? issue.getAttachments() : Collections.EMPTY_LIST;
            if (attachmentIds == null) {
                return new ArrayList<Attachment>(issueAttachments);
            }
            LinkedList<Attachment> result = new LinkedList<Attachment>(issueAttachments);
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (attachmentIds.contains(((Attachment)it.next()).getId())) continue;
                it.remove();
            }
            return result;
        }
    }
    ,
    LATEST{

        @Override
        public List<Attachment> filterAttachments(Issue issue, Set<Long> attachmentIds) {
            Collection issueAttachments = issue != null ? issue.getAttachments() : Collections.EMPTY_LIST;
            HashMap<String, Attachment> latestOnes = new HashMap<String, Attachment>();
            for (Attachment a : issueAttachments) {
                if (latestOnes.containsKey(a.getFilename())) {
                    Attachment latest = (Attachment)latestOnes.get(a.getFilename());
                    if (!a.getCreated().after(latest.getCreated())) continue;
                    latestOnes.put(a.getFilename(), a);
                    continue;
                }
                latestOnes.put(a.getFilename(), a);
            }
            return new ArrayList<Attachment>(latestOnes.values());
        }
    }
    ,
    ADDED_LAST{

        @Override
        public List<Attachment> filterAttachments(Issue issue, Set<Long> attachmentIds) {
            Collection issueAttachments = issue != null ? issue.getAttachments() : Collections.EMPTY_LIST;
            Timestamp maxCreated = null;
            for (Attachment a : issueAttachments) {
                if (maxCreated != null && !maxCreated.before((Date)a.getCreated())) continue;
                maxCreated = a.getCreated();
            }
            LinkedList<Attachment> result = new LinkedList<Attachment>();
            if (maxCreated != null) {
                for (Attachment a : issueAttachments) {
                    if (!((Date)maxCreated).equals(a.getCreated()) && Math.abs(((Date)maxCreated).getTime() - a.getCreated().getTime()) >= 1000L) continue;
                    result.add(a);
                }
            }
            return result;
        }
    }
    ,
    FIELD{

        @Override
        public List<Attachment> filterAttachments(Issue issue, Set<Long> attachmentIds) {
            Collection selectedAttachments;
            Attachment[] attachments = new Attachment[]{};
            CustomField attachmentSelectorField = CustomFieldUtil.firstFieldByType(ComponentAccessor.getCustomFieldManager().getCustomFieldObjects(issue), AttachmentSelectorFieldType.class);
            if (attachmentSelectorField != null && (selectedAttachments = (Collection)issue.getCustomFieldValue(attachmentSelectorField)) != null && !selectedAttachments.isEmpty()) {
                attachments = selectedAttachments.toArray(new Attachment[0]);
            }
            return Arrays.asList(attachments);
        }
    };


    public abstract List<Attachment> filterAttachments(Issue var1, Set<Long> var2);

    public static AddAttachmentType getByName(String name) {
        try {
            return AddAttachmentType.valueOf(name);
        }
        catch (Exception e) {
            return name == null || "false".equalsIgnoreCase(name) ? NONE : LATEST;
        }
    }
}

