/**
 * creates a picker around the $picker AUI jQuery object
 * @param $picker
 * @param type 'user' or 'group' or 'role' or 'permission'
 * @param multi whether it should support multiple values
 * @param allowClear allow clearing single-valued picker
 */
function createPicker($picker, type, multi, allowClear) {
    var temp = type.split("/");
    type = temp[0];
    var subType;
    if (temp.length>1)
        subType = temp[1];
    $picker.auiSelect2({
        hasAvatar: type == 'user', // auiSelect2 specific option, adds styling needed to properly display avatars
        multiple: multi, // make the control a multi-select
        allowClear: allowClear,
        //maximumSelectionSize: multi?1000 : 1,
        ajax: {
            url: AJS.contextPath() +
            (type == 'user' ? "/rest/api/2/user/picker" :
                (type == 'group' ? "/rest/api/2/groups/picker" :
                    (type == 'role' ? "/rest/" + addonShortKey + "/1/role/picker" :
                        (type == 'permission' ? "/rest/" + addonShortKey + "/1/permission/picker" : 
                            (type == 'field' ? "/rest/" + addonShortKey + "/1/field/picker/"+subType :
                                null))))), // JIRA-relative URL to the REST end-point
            type: "GET",
            dataType: 'json',
            cache: true,
            // query parameters for the remote ajax call
            data: function data(term) {
                return {
                    query: term,
                    maxResults: 1000,
                    showAvatar: true
                };
            },
            // parse data from the server into form select2 expects
            results: function results(data) {
                return {
                    results: type == 'user' ? data.users : (type == 'group' ? data.groups : data)
                };
            }
        },
        // specify id parameter of each user entity
        id: function id(obj) {
            if (type == 'user' || type == 'group')
                return obj.name;
            else if (type == 'field' || type == 'permission')
                return obj.key;
            else
                return obj.id;
        }
        ,
        // define how selected element should look like
        formatSelection: function formatSelection(obj) {
            if (type == 'user') {
                var avatarHtml = aui.avatar.avatar({
                    size: 'xxsmall',
                    avatarImageUrl: obj.avatarUrl
                });
                return avatarHtml + Select2.util.escapeMarkup(obj.displayName);
            } else {
                return Select2.util.escapeMarkup(obj.displayName || obj.name);
            }
        }
        ,
        // define how single option should look like
        formatResult: function formatResult(obj, container, query, escapeMarkup) {
            if (type == 'user') {
                var avatarHtml = aui.avatar.avatar({
                    size: 'small',
                    avatarImageUrl: obj.avatarUrl
                });
                return avatarHtml + obj.html;
            } else
                return obj.html || Select2.util.escapeMarkup(obj.displayName || obj.name);
        }
        ,
        initSelection: function (element, callback) {
            if (type == 'user') {
                var data = [];
                var values;
                if (multi)
                    values = element.val().split(",");
                else
                    values = [element.val()];
                var countDown = values.length;
                AJS.$(values).each(function () {
                    AJS.$.ajax({
                        url: AJS.contextPath() + "/rest/api/2/user?username=" + this,
                        headers: {
                            "Accept": "application/json"
                        },
                        success: function (user) {
                            user.avatarUrl = user.avatarUrls["16x16"];
                            if (multi) {
                                data.push(user);
                                if (--countDown == 0) {
                                    callback(data);
                                }
                            } else
                                callback(user);
                        },
                        error: function (e) {
                            if (multi && --countDown == 0)
                                callback(data);
                        }
                    });
                });
            } else if (type == 'role') {
                AJS.$.ajax({
                    url: AJS.contextPath() + "/rest/" + addonShortKey + "/1/role/picker",
                    headers: {
                        "Accept": "application/json"
                    },
                    success: function (roles) {
                        var data = [];
                        var values;
                        if (multi)
                            values = element.val().split(",");
                        else
                            values = [element.val()];
                        roles.forEach(function (role) {
                            if (values.find(function (elem) {
                                    return elem == role.id;
                                }))
                                data.push(role);
                        });
                        callback(data);
                    },
                    error: function (e) {
                        callback([]);
                    }
                });
            } else if (type == 'permission') {
                AJS.$.ajax({
                    url: AJS.contextPath() + "/rest/" + addonShortKey + "/1/permission/picker",
                    headers: {
                        "Accept": "application/json"
                    },
                    success: function (permissions) {
                        var data = [];
                        var values;
                        if (multi)
                            values = element.val().split(",");
                        else
                            values = [element.val()];
                        permissions.forEach(function (permission) {
                            if (values.find(function (elem) {
                                    return elem == permission.key;
                                }))
                                data.push(permission);
                        });
                        callback(data);
                    },
                    error: function (e) {
                        callback([]);
                    }
                });
            } else if (type == 'field') {
                AJS.$.ajax({
                    url: AJS.contextPath() + "/rest/" + addonShortKey + "/1/field/picker/"+subType,
                    headers: {
                        "Accept": "application/json"
                    },
                    success: function (fields) {
                        var data = [];
                        var values;
                        if (multi)
                            values = element.val().split(",");
                        else
                            values = [element.val()];
                        fields.forEach(function (field) {
                            if (values.find(function (elem) {
                                    return elem == field.key;
                                }))
                                data.push(field);
                        });
                        callback(data);
                    },
                    error: function (e) {
                        callback([]);
                    }
                });
            } else {
                if (multi) {
                    var data = [];
                    AJS.$(element.val().split(",")).each(function () {
                        data.push({name: this});
                    });
                    callback(data);
                } else
                    callback({
                        name: element.val()
                    });
            }
        },
        // define message showed when there are no matches
        formatNoMatches: function formatNoMatches(query) {
            return "No matches found";
        }
    });
    setTimeout(function () {
        $picker.parent().find('.select2-input').trigger('blur');
    }, 500);
}