var addonShortKey = 'jmwe';

var formValidation = require('aui/form-validation');

AJS.$(document).ready(function () {
    AJS.$("form.aui").on('click', '.jmwe-icon-inline-help', function () {
        var $t = AJS.$(this).siblings('.field-help');
        if ($t.hasClass('hidden')){
            $t.removeClass('hidden');
        } else {
            $t.addClass('hidden');
        }
    });

    AJS.$("form[name='jiraform']").on('submit', function (event) {
        AJS.$("textarea.codeEditor").each(function () {
            if (AJS.$(this).data("editor"))
                AJS.$(this).data("editor").save();
        });

        AJS.$("textarea.codeEditor[data-aui-validation-field]").each(function (index, elem) {
            formValidation.validate(AJS.$(elem));
        });
    });

    //remove the stupid submit listener that prevent multiple submits, because it interferes with form-validation
    AJS.$("form[name='jiraform']").attr("onsubmit", null);
    AJS.$("form[name='jiraform']").on('aui-valid-submit', function (e) {
        if (this.submitted)
            e.preventDefault();
        else
            this.submitted = true;
    });

    //for autoexpand textareas
    AJS.$(document)
        .on('focus.autoExpand', 'textarea.autoExpand', function () {
            if (!this.baseScrollHeight) {
                var savedValue = this.value;
                this.value = '';
                this.baseScrollHeight = this.scrollHeight;
                this.value = savedValue;
            }
        })
        .on('input.autoExpand', 'textarea.autoExpand', function () {
            var minRows = this.getAttribute('data-min-rows') | 0, rows;
            this.rows = minRows;
            rows = Math.ceil((this.scrollHeight - this.baseScrollHeight) / 20);
            this.rows = minRows + rows;
        });
    AJS.$('textarea.autoExpand').each(function () {
        var savedValue = this.value;
        this.value = '';
        this.baseScrollHeight = this.scrollHeight;
        this.value = savedValue;
        var minRows = this.getAttribute('data-min-rows') | 0, rows;
        this.rows = minRows;
        rows = Math.ceil((this.scrollHeight - this.baseScrollHeight) / 20);
        this.rows = minRows + rows;
    });

    AJS.$('.initially-hidden').hide();

    window.setTimeout(function () {
        var autoFocus = AJS.$("[autofocus]");
        if (autoFocus.size() > 0) {
            autoFocus = AJS.$(autoFocus[0]);
            const editor = autoFocus.data("editor");
            if (editor && editor.codeMirrorInstance) {
                editor.codeMirrorInstance.focus();
            } else {
                autoFocus.focus();
            }
        }
    }, 50);
});
