/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.workflow.utils;

import com.atlassian.jira.issue.attachment.Attachment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FieldValueHolder {
    private final List<Object> values;
    private final boolean singleValue;

    public FieldValueHolder() {
        this.values = null;
        this.singleValue = true;
    }

    public FieldValueHolder(Object s) {
        this.values = s instanceof CharSequence && StringUtils.isEmpty((CharSequence)s) ? null : Collections.singletonList(s);
        this.singleValue = true;
    }

    public FieldValueHolder(Collection<Object> objects) {
        this.values = new ArrayList<Object>(objects);
        this.singleValue = false;
    }

    public static String toCFString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            return (String)value;
        }
        if (value instanceof Number) {
            return ((Number)value).toString();
        }
        if (value instanceof Date) {
            return ((Date)value).toString();
        }
        if (value instanceof Attachment) {
            return ((Attachment)value).getFilename();
        }
        return value.toString();
    }

    public boolean isNull() {
        return this.values == null;
    }

    public boolean isEmpty() {
        return this.values == null || this.values.isEmpty() || this.values.get(0) == null || this.values.size() == 1 && this.values.get(0) instanceof String && StringUtils.isEmpty((CharSequence)this.values.get(0));
    }

    public boolean isSingleValue() {
        return this.singleValue;
    }

    public List<String> getMultiStringValues(String separatorRegExp) {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.isSingleValue() && this.values.get(0) instanceof String) {
            return Arrays.asList(((String)this.values.get(0)).split(separatorRegExp));
        }
        ArrayList<String> res = new ArrayList<String>(this.values.size());
        for (Object o : this.values) {
            res.add(FieldValueHolder.toCFString(o));
        }
        return res;
    }

    public List<Object> getMultiValues(String separatorRegExp) {
        if (this.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.isSingleValue() && this.values.get(0) instanceof String) {
            return Arrays.asList(((String)this.values.get(0)).split(separatorRegExp));
        }
        return this.values;
    }

    public String getSingleStringValue(String separator) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.isSingleValue()) {
            return FieldValueHolder.toCFString(this.values.get(0));
        }
        ArrayList<String> strings = new ArrayList<String>(this.values.size());
        for (Object value : this.values) {
            strings.add(FieldValueHolder.toCFString(value));
        }
        return StringUtils.join(strings, separator);
    }

    public Object getValue(int index) {
        if (this.values == null) {
            return null;
        }
        return this.values.get(index);
    }

    public int size() {
        return this.values == null ? 0 : this.values.size();
    }

    public String toString() {
        if (this.values == null) {
            return "null";
        }
        if (this.singleValue) {
            return this.values.get(0).toString();
        }
        Iterator<Object> iterator = this.values.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        while (iterator.hasNext()) {
            sb.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public Object getFirstValueOrNull() {
        return this.isEmpty() ? null : this.values.get(0);
    }

    public void append(FieldValueHolder valueHolder) {
        if (this.isSingleValue()) {
            throw new UnsupportedOperationException("Can't append data to single-valued field");
        }
        this.values.addAll(valueHolder.values);
    }
}

