/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.servlet;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.storage.lib.AtlassianMarketplaceUriFactory;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class LicenseServlet
extends HttpServlet {
    private static final String TEMPLATE = "license-admin.vm";
    private final ThirdPartyPluginLicenseStorageManager licenseManager;
    private final AtlassianMarketplaceUriFactory uriFactory;
    private final ApplicationProperties applicationProperties;
    private final TemplateRenderer renderer;
    private final LoginUriProvider loginUriProvider;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;

    public LicenseServlet(ThirdPartyPluginLicenseStorageManager licenseManager, AtlassianMarketplaceUriFactory uriFactory, ApplicationProperties applicationProperties, TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserManager userManager, I18nResolver i18nResolver) {
        this.licenseManager = licenseManager;
        this.uriFactory = uriFactory;
        this.applicationProperties = applicationProperties;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.userManager.getRemoteUsername() == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        if (!this.hasAdminPermission()) {
            this.handleUnpermittedUser(req, resp);
            return;
        }
        Map<String, Object> context = this.initVelocityContext(resp);
        this.addEligibleMarketplaceButtons(context);
        this.renderer.render(TEMPLATE, context, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.userManager.getRemoteUsername() == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        if (!this.hasAdminPermission()) {
            this.handleUnpermittedUser(req, resp);
            return;
        }
        Map<String, Object> context = this.initVelocityContext(resp);
        if (!context.containsKey("errorMessage")) {
            try {
                if (!this.licenseManager.isUpmLicensingAware()) {
                    String license = req.getParameter("license");
                    Option<PluginLicense> validatedLicense = this.licenseManager.validateLicense(license);
                    if (StringUtils.isEmpty((String)license)) {
                        this.licenseManager.removeRawLicense();
                        context.put("successMessage", this.i18nResolver.getText("plugin.license.storage.admin.license.remove"));
                        context.put("license", this.licenseManager.getLicense());
                    } else if (validatedLicense.isDefined()) {
                        this.licenseManager.setRawLicense(license);
                        if (((PluginLicense)validatedLicense.get()).getError().isDefined()) {
                            context.put("warningMessage", this.i18nResolver.getText("plugin.license.storage.admin.license.update.invalid"));
                        } else {
                            context.put("successMessage", this.i18nResolver.getText("plugin.license.storage.admin.license.update"));
                        }
                        context.put("license", this.licenseManager.getLicense());
                    } else {
                        context.put("errorMessage", this.i18nResolver.getText("plugin.license.storage.admin.license.invalid"));
                    }
                }
            }
            catch (PluginLicenseStoragePluginUnresolvedException e) {
                context.put("errorMessage", this.i18nResolver.getText("plugin.license.storage.admin.plugin.unavailable"));
                context.put("displayLicenseAdminUi", false);
            }
        }
        this.addEligibleMarketplaceButtons(context);
        this.renderer.render(TEMPLATE, context, (Writer)resp.getWriter());
    }

    private Map<String, Object> initVelocityContext(HttpServletResponse resp) {
        resp.setContentType("text/html;charset=utf-8");
        URI servletUri = URI.create(this.applicationProperties.getBaseUrl() + "/plugins/servlet/com.innovalog.jmwe.jira-misc-workflow-extensions/license");
        URI workflowsUri = URI.create(this.applicationProperties.getBaseUrl() + "/secure/admin/workflows/ListWorkflows.jspa");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("servletUri", servletUri);
        context.put("workflowsUri", workflowsUri);
        context.put("displayLicenseAdminUi", true);
        try {
            context.put("license", this.licenseManager.getLicense());
            context.put("upmLicensingAware", this.licenseManager.isUpmLicensingAware());
            context.put("pluginKey", this.licenseManager.getPluginKey());
            if (this.licenseManager.isUpmLicensingAware()) {
                context.put("warningMessage", this.i18nResolver.getText("plugin.license.storage.admin.upm.licensing.aware", new Serializable[]{this.licenseManager.getPluginManagementUri()}));
            }
        }
        catch (PluginLicenseStoragePluginUnresolvedException e) {
            context.put("errorMessage", this.i18nResolver.getText("plugin.license.storage.admin.plugin.unavailable"));
            context.put("displayLicenseAdminUi", false);
        }
        return context;
    }

    private void addEligibleMarketplaceButtons(Map<String, Object> context) {
        URI servletUri = URI.create(this.applicationProperties.getBaseUrl() + "/plugins/servlet/com.innovalog.jmwe.jira-misc-workflow-extensions/license");
        try {
            boolean eligibleButtons = false;
            if (this.uriFactory.isPluginBuyable()) {
                context.put("buyPluginUri", this.uriFactory.getBuyPluginUri(servletUri));
                eligibleButtons = true;
            }
            if (this.uriFactory.isPluginTryable()) {
                context.put("tryPluginUri", this.uriFactory.getTryPluginUri(servletUri));
                eligibleButtons = true;
            }
            if (this.uriFactory.isPluginRenewable()) {
                context.put("renewPluginUri", this.uriFactory.getRenewPluginUri(servletUri));
                eligibleButtons = true;
            }
            if (this.uriFactory.isPluginUpgradable()) {
                context.put("upgradePluginUri", this.uriFactory.getUpgradePluginUri(servletUri));
                eligibleButtons = true;
            }
            context.put("eligibleButtons", eligibleButtons);
        }
        catch (PluginLicenseStoragePluginUnresolvedException e) {
            context.put("errorMessage", this.i18nResolver.getText("plugin.license.storage.admin.plugin.unavailable"));
            context.put("displayLicenseAdminUi", false);
        }
    }

    private boolean hasAdminPermission() {
        String user = this.userManager.getRemoteUsername();
        try {
            return user != null && (this.userManager.isAdmin(user) || this.userManager.isSystemAdmin(user));
        }
        catch (NoSuchMethodError e) {
            return user != null && this.userManager.isSystemAdmin(user);
        }
    }

    private void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(req.getRequestURL().toString())).toASCIIString());
    }

    private void handleUnpermittedUser(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("errorMessage", this.i18nResolver.getText("plugin.license.storage.admin.unpermitted"));
        context.put("displayLicenseAdminUi", false);
        this.renderer.render(TEMPLATE, context, (Writer)resp.getWriter());
    }
}

