/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.servlet;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LicenseHelloWorldServlet
extends HttpServlet {
    private final ThirdPartyPluginLicenseStorageManager licenseManager;

    public LicenseHelloWorldServlet(ThirdPartyPluginLicenseStorageManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/html");
        resp.getWriter().write("<html><body>");
        try {
            if (this.licenseManager.getLicense().isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                if (pluginLicense.getError().isDefined()) {
                    resp.getWriter().write("I'd love to say hello, but cannot do so because your license has an error: " + ((LicenseError)pluginLicense.getError().get()).name());
                } else {
                    resp.getWriter().write("Hello, world! You are licensed!");
                }
            } else {
                resp.getWriter().write("I'd love to say hello, but cannot do so because you don't have a license.");
            }
        }
        catch (PluginLicenseStoragePluginUnresolvedException e) {
            resp.getWriter().write("I'd love to say hello, but cannot find my required resources. Please speak to a system administrator.");
        }
        resp.getWriter().write("</body></html>");
        resp.getWriter().close();
    }
}

