/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.rest;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/workflows")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class WorkflowApi {
    private final WorkflowManager workflowManager;
    private final GlobalPermissionManager globalPermissionManager;

    public WorkflowApi(WorkflowManager workflowManager, GlobalPermissionManager globalPermissionManager) {
        this.workflowManager = workflowManager;
        this.globalPermissionManager = globalPermissionManager;
    }

    @GET
    @Path(value="")
    public Response getWorkflows() {
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List workflows = this.workflowManager.getWorkflowsIncludingDrafts();
        Workflows response = new Workflows();
        for (JiraWorkflow workflow : workflows) {
            String displayName = workflow.getDisplayName();
            if (workflow.isDraftWorkflow()) {
                displayName = displayName + " (Draft)";
            }
            response.addWorkflow(workflow.getName(), displayName, workflow.isDraftWorkflow(), workflow.isActive());
        }
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/{workflowName}")
    public Response getWorkflow(@PathParam(value="workflowName") String workflowName) {
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String displayName = workflow.getDisplayName();
        if (workflow.isDraftWorkflow()) {
            displayName = displayName + " (Draft)";
        }
        WorkflowEntry workflowEntry = new WorkflowEntry(workflow.getName(), displayName, workflow.isDraftWorkflow());
        ArrayList<TransitionEntry> transitions = new ArrayList<TransitionEntry>();
        for (ActionDescriptor actionDescriptor : workflow.getAllActions()) {
            if (actionDescriptor.getId() == 1) continue;
            transitions.add(new TransitionEntry(actionDescriptor.getName(), actionDescriptor.getId()));
        }
        workflowEntry.setTransitions(transitions);
        return Response.ok((Object)workflowEntry).build();
    }

    @GET
    @Path(value="/{workflowName}/draft")
    public Response getDraftWorkflow(@PathParam(value="workflowName") String workflowName) {
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        JiraWorkflow workflow = this.workflowManager.getDraftWorkflow(workflowName);
        if (workflow == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String displayName = workflow.getDisplayName();
        if (workflow.isDraftWorkflow()) {
            displayName = displayName + " (Draft)";
        }
        WorkflowEntry workflowEntry = new WorkflowEntry(workflow.getName(), displayName, workflow.isDraftWorkflow());
        ArrayList<TransitionEntry> transitions = new ArrayList<TransitionEntry>();
        for (ActionDescriptor actionDescriptor : workflow.getAllActions()) {
            if (actionDescriptor.getId() == 1) continue;
            transitions.add(new TransitionEntry(actionDescriptor.getName(), actionDescriptor.getId()));
        }
        workflowEntry.setTransitions(transitions);
        return Response.ok((Object)workflowEntry).build();
    }

    @XmlRootElement
    public class Workflows {
        @XmlElement
        private List<WorkflowEntry> activeWorkflows = new ArrayList<WorkflowEntry>();
        @XmlElement
        private List<WorkflowEntry> draftWorkflows = new ArrayList<WorkflowEntry>();
        @XmlElement
        private List<WorkflowEntry> inactiveWorkflows = new ArrayList<WorkflowEntry>();

        public void addWorkflow(String name, String displayName, boolean isDraft, boolean isActive) {
            if (isDraft) {
                this.draftWorkflows.add(new WorkflowEntry(name, displayName, true));
            } else if (isActive) {
                this.activeWorkflows.add(new WorkflowEntry(name, displayName, false));
            } else {
                this.inactiveWorkflows.add(new WorkflowEntry(name, displayName, false));
            }
        }
    }

    @XmlRootElement
    public class TransitionEntry {
        @XmlElement
        private String name;
        @XmlElement
        private Integer id;

        public TransitionEntry(String name, int id) {
            this.name = name;
            this.id = id;
        }
    }

    @XmlRootElement
    public static class WorkflowEntry {
        @XmlElement
        private String name;
        @XmlElement
        private String displayName;
        @XmlElement
        private Boolean isDraft;
        @XmlElement
        private List<TransitionEntry> transitions;

        public WorkflowEntry(String name, String displayName, boolean isDraft) {
            this.name = name;
            this.displayName = displayName;
            this.isDraft = isDraft;
        }

        public void setTransitions(List<TransitionEntry> list) {
            this.transitions = list;
        }
    }
}

