/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.rest;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.innovalog.jmwe.PreferencesService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/prefs")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PreferencesApi {
    private final GlobalPermissionManager globalPermissionManager;
    private final PreferencesService preferencesService;

    public PreferencesApi(GlobalPermissionManager globalPermissionManager, PreferencesService preferencesService) {
        this.globalPermissionManager = globalPermissionManager;
        this.preferencesService = preferencesService;
    }

    @POST
    @Path(value="/throwExceptions")
    public Response setThrowExceptions(Boolean b) {
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.preferencesService.setThrowExceptions(b);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/throwExceptions")
    public Response delThrowExceptions() {
        ApplicationUser currentUser = ComponentAccessor.getJiraAuthenticationContext().getUser();
        if (currentUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.preferencesService.clearThrowExceptions();
        return Response.ok().build();
    }
}

