/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.comparator.IssueStatusComparator;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class WorkflowParentStatusValidator
extends AbstractLicensedWorkflowPluginFactory
implements WorkflowPluginValidatorFactory {
    private final ConstantsManager constantsManager;

    protected WorkflowParentStatusValidator(ThirdPartyPluginLicenseStorageManager licenseManager, ConstantsManager constantsManager) {
        super(licenseManager);
        this.constantsManager = constantsManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        String statusString = (String)validatorDescriptor.getArgs().get("jira.parentstatuses");
        velocityParams.put("selectedStatuses", WorkflowParentStatusValidator.getStringSet(statusString));
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        velocityParams.put("statuses", this.constantsManager.getStatusObjects());
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        String statusString = (String)validatorDescriptor.getArgs().get("jira.parentstatuses");
        Set<String> selectedStatusNames = WorkflowParentStatusValidator.getStringSet(statusString);
        LinkedList<Status> selectedStatuses = new LinkedList<Status>();
        for (String statusName : selectedStatusNames) {
            selectedStatuses.add(this.constantsManager.getStatusByName(statusName));
        }
        Collections.sort(selectedStatuses, new IssueStatusComparator());
        velocityParams.put("selectedStatuses", Collections.unmodifiableCollection(selectedStatuses));
    }

    static Set<String> getStringSet(String s) {
        if (s == null) {
            return Collections.EMPTY_SET;
        }
        String[] arr = s.split("@@");
        HashSet<String> set = new HashSet<String>();
        for (String s1 : arr) {
            set.add(s1);
        }
        return set;
    }

    public Map getDescriptorParams(Map formParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String[] selectedStatuses = (String[])formParams.get("issue_statuses");
            StringBuilder sb = new StringBuilder();
            for (String s : selectedStatuses) {
                sb.append(s).append("@@");
            }
            params.put("jira.parentstatuses", sb.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return params;
    }
}

