/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowFieldHasSingleValueValidator
extends AbstractLicensedWorkflowPluginFactory
implements WorkflowPluginValidatorFactory {
    public static final String FIELDKEY = "fieldKey";
    public static final String SELECTED_FIELD = "selectedField";
    public static final String FIELD_LIST = "fieldList";
    private final FieldCollectionsUtils fieldCollectionsUtils;
    private final FieldManager fieldManager;

    public WorkflowFieldHasSingleValueValidator(FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, FieldManager fieldManager) {
        super(licenseManager);
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.fieldManager = fieldManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        List<Field> fields = this.fieldCollectionsUtils.getAllMultiEditableFields();
        velocityParams.put(FIELD_LIST, Collections.unmodifiableList(fields));
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        Map args = validatorDescriptor.getArgs();
        String strFieldKey = (String)args.get(FIELDKEY);
        velocityParams.put(SELECTED_FIELD, this.fieldManager.getField(strFieldKey));
        String excludingSubtasks = (String)validatorDescriptor.getArgs().get("jira.excludingSubtasks");
        velocityParams.put("excludingSubtasks", excludingSubtasks);
    }

    public Map<String, String> getDescriptorParams(Map formParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String sourceField = this.extractSingleParam(formParams, "field");
            params.put(FIELDKEY, sourceField);
        }
        catch (IllegalArgumentException sourceField) {
            // empty catch block
        }
        try {
            String excludingSubtasks = this.extractSingleParam(formParams, "excludingSubtasks");
            params.put("jira.excludingSubtasks", excludingSubtasks);
        }
        catch (IllegalArgumentException e) {
            params.put("jira.excludingSubtasks", "no");
        }
        return params;
    }
}

