/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.annotation.Argument;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.validators.GenericValidator;
import com.innovalog.jmwe.plugins.validators.WorkflowParentStatusValidator;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class ParentStatusValidator
extends GenericValidator {
    private final I18nResolver i18nResolver;
    @Argument(value="jira.parentstatuses")
    private String parentStatuses;

    public ParentStatusValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, I18nResolver i18nResolver) {
        super(workflowUtils, fieldCollectionsUtils, licenseManager);
        this.i18nResolver = i18nResolver;
    }

    @Override
    public void doValidate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException {
        Issue genericIssue = this.getIssue();
        Set<String> statuses = WorkflowParentStatusValidator.getStringSet(this.parentStatuses);
        Issue parentIssue = genericIssue.getParentObject();
        if (parentIssue == null) {
            return;
        }
        Status parentStatus = parentIssue.getStatusObject();
        if (parentStatus != null && !statuses.contains(parentStatus.getName())) {
            throw new InvalidInputException(this.i18nResolver.getText("parent.status.validator.msg", new Serializable[]{StringEscapeUtils.escapeHtml((String)statuses.toString())}));
        }
    }
}

