/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.validators.GenericValidator;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedIssuesStatusValidator
extends GenericValidator {
    private final I18nResolver i18nResolver;
    private Logger log = LoggerFactory.getLogger(LinkedIssuesStatusValidator.class);
    private final IssueLinkManager issueLinkManager;
    private final ConstantsManager constantsManager;

    public LinkedIssuesStatusValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, I18nResolver i18nResolver, IssueLinkManager issueLinkManager, ConstantsManager constantsManager) {
        super(workflowUtils, fieldCollectionsUtils, licenseManager);
        this.i18nResolver = i18nResolver;
        this.issueLinkManager = issueLinkManager;
        this.constantsManager = constantsManager;
    }

    @Override
    protected void doValidate(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        Long linkTypeId;
        Issue issue = (Issue)transientVars.get("issue");
        String rawLinkType = (String)args.get("selectedLinkType");
        String errorMessage = (String)args.get("errorMessage");
        String statuses = (String)args.get("statuses");
        boolean isInwardLink = rawLinkType.split(":")[0].equalsIgnoreCase("inward");
        try {
            linkTypeId = new Long(Long.parseLong(rawLinkType.split(":")[1]));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            this.log.error(sb.append("LinkedIssuesStatusValidator not configured with a valid link type ID: ").append(rawLinkType).append(" cannot be parsed.").toString());
            return;
        }
        List links = isInwardLink ? this.issueLinkManager.getInwardLinks(issue.getId()) : this.issueLinkManager.getOutwardLinks(issue.getId());
        for (IssueLink issueLink : links) {
            String msg;
            if (!issueLink.getLinkTypeId().equals(linkTypeId)) continue;
            Issue linkedIssue = isInwardLink ? issueLink.getSourceObject() : issueLink.getDestinationObject();
            boolean inRightStatus = false;
            StringTokenizer st = new StringTokenizer(statuses, ",");
            while (st.hasMoreTokens()) {
                String statusId = st.nextToken();
                if (!linkedIssue.getStatusId().equals(statusId)) continue;
                inRightStatus = true;
                break;
            }
            if (inRightStatus) continue;
            if (errorMessage != null && errorMessage.length() > 0) {
                msg = errorMessage;
            } else {
                Collection allStatuses = this.constantsManager.getStatusObjects();
                StringBuilder sb = new StringBuilder();
                for (String statusId : statuses.split(",")) {
                    for (Status status : allStatuses) {
                        if (!status.getId().equals(statusId)) continue;
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(status.getNameTranslation());
                    }
                }
                msg = this.i18nResolver.getText("linked.issues.status.validator.msg", new Serializable[]{linkedIssue.getKey(), sb.toString()});
            }
            throw new InvalidInputException(msg);
        }
    }
}

