/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.annotation.Argument;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.jmwe.plugins.validators.GenericValidator;
import com.innovalog.workflow.utils.FieldValueService;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;

public class GroovyValidator
extends GenericValidator {
    private final FieldValueService fieldValueService;
    private final ScriptManager scriptManager;
    @Argument(value="errorMessage")
    private String errorMsg;
    @Argument(value="groovyExpression")
    private String groovyExpression;

    public GroovyValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, FieldValueService fieldValueService, ScriptManager scriptManager) {
        super(workflowUtils, fieldCollectionsUtils, licenseManager);
        this.fieldValueService = fieldValueService;
        this.scriptManager = scriptManager;
    }

    @Override
    protected void doValidate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException, WorkflowException {
        if (this.groovyExpression == null || this.groovyExpression.isEmpty()) {
            return;
        }
        this.groovyExpression = Utils.decodeTemplate(this.groovyExpression);
        GroovyExpression expression = new GroovyExpression(this.groovyExpression, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
        expression.addIssueVariable("issue", this.getIssue());
        if (!((Boolean)expression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            throw new InvalidInputException(this.errorMsg);
        }
    }
}

