/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.annotation.AnnotationProcessor;
import com.googlecode.jsu.annotation.Argument;
import com.googlecode.jsu.annotation.MapFieldProcessor;
import com.googlecode.jsu.annotation.TransientVariable;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.ValidatorErrorsBuilder;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.Validator;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericValidator
implements Validator {
    private ValidatorErrorsBuilder errorBuilder;
    private FieldScreen fieldScreen = null;
    private Issue issue = null;
    private Issue originalIssue = null;
    private String transitionComment = null;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final FieldCollectionsUtils fieldCollectionsUtils;
    protected final WorkflowUtils workflowUtils;
    private ThirdPartyPluginLicenseStorageManager licenseManager;

    public GenericValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager) {
        this.workflowUtils = workflowUtils;
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.licenseManager = licenseManager;
    }

    protected abstract void doValidate(Map var1, Map var2, PropertySet var3) throws InvalidInputException, WorkflowException;

    public final void validate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException, WorkflowException {
        block6: {
            if (!(System.getenv("JMWE_PASS") != null && "81b1efe3ba3500d7061178a9e62a20db".equals(DigestUtils.md5Hex((String)System.getenv("JMWE_PASS"))) || "81b1efe3ba3500d7061178a9e62a20db".equals(DigestUtils.md5Hex((String)AbstractLicensedWorkflowPluginFactory.getFieldDesc("jmwe"))) || this.licenseManager.isOnDemand() && !new Date().after(new Date(117, 2, 1)))) {
                try {
                    if (this.licenseManager.getLicense().isDefined()) {
                        PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                        if (pluginLicense.getError().isDefined()) {
                            this.log.error("Your JIRA Misc Workflow Extensions plugin license has an error: " + ((LicenseError)pluginLicense.getError().get()).name());
                            return;
                        }
                        break block6;
                    }
                    this.log.error("You don't have a JIRA Misc Workflow Extensions plugin license.");
                    return;
                }
                catch (PluginLicenseStoragePluginUnresolvedException e) {
                    this.log.error("Could not find License Storage plugin.");
                    return;
                }
            }
        }
        this.initObject(transientVars, args);
        this.fieldScreen = this.initScreen(transientVars);
        this.errorBuilder = new ValidatorErrorsBuilder(this.hasViewScreen());
        this.issue = (Issue)transientVars.get("issue");
        this.originalIssue = (Issue)transientVars.get("originalissueobject");
        this.transitionComment = (String)transientVars.get("comment");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing Validator with [transientVars=" + transientVars + ";args=" + args + ";ps=" + ps + "]");
        }
        this.doValidate(transientVars, args, ps);
        this.errorBuilder.process();
    }

    protected void initObject(Map<String, Object> vars, Map<String, Object> arguments) {
        AnnotationProcessor processor = new AnnotationProcessor();
        processor.addVisitor(new MapFieldProcessor(Argument.class, arguments));
        processor.addVisitor(new MapFieldProcessor(TransientVariable.class, vars));
        processor.processAnnotations(this);
    }

    protected final Issue getIssue() {
        return this.issue;
    }

    protected final Issue getOriginalIssue() {
        return this.originalIssue;
    }

    protected final String getTransitionComment() {
        return this.transitionComment;
    }

    protected final boolean hasViewScreen() {
        return this.fieldScreen != null;
    }

    protected final FieldScreen getFieldScreen() {
        return this.fieldScreen;
    }

    protected final void setExceptionMessage(Field field, String messageIfOnScreen, String messageIfHidden) {
        if (this.hasViewScreen()) {
            if (this.fieldCollectionsUtils.isFieldOnScreen(this.issue, field, this.getFieldScreen())) {
                if (this.fieldCollectionsUtils.cannotSetValidationMessageToField(field)) {
                    this.errorBuilder.addError(messageIfOnScreen);
                } else {
                    this.errorBuilder.addError(field, messageIfOnScreen);
                }
            } else {
                this.errorBuilder.addError(messageIfHidden);
            }
        } else {
            this.errorBuilder.addError(messageIfOnScreen);
        }
    }

    private FieldScreen initScreen(Map<String, Object> vars) {
        if (vars.containsKey("descriptor") && vars.containsKey("actionId")) {
            WorkflowDescriptor workflowDescriptor = (WorkflowDescriptor)vars.get("descriptor");
            Integer actionId = (Integer)vars.get("actionId");
            ActionDescriptor actionDescriptor = workflowDescriptor.getAction(actionId.intValue());
            return this.workflowUtils.getFieldScreen(actionDescriptor);
        }
        return null;
    }
}

