/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.annotation.Argument;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.validators.GenericValidator;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FieldRequiredValidator
extends GenericValidator {
    @Argument(value="fieldKey")
    private String fieldKey;
    @Argument(value="hidFieldsList")
    private String fieldsListFromCloud;
    @Argument(value="errorMessage")
    private String errorMsg;
    private final I18nHelper.BeanFactory beanFactory;
    private final VersionManager versionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public FieldRequiredValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, I18nHelper.BeanFactory beanFactory, VersionManager versionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        super(workflowUtils, fieldCollectionsUtils, licenseManager);
        this.beanFactory = beanFactory;
        this.versionManager = versionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    protected void doValidate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException, WorkflowException {
        String fieldList;
        if (StringUtils.isBlank(this.fieldsListFromCloud)) {
            fieldList = this.fieldKey;
        } else {
            fieldList = this.fieldsListFromCloud.replaceAll("@@", ",");
            if (fieldList.endsWith(",")) {
                fieldList = fieldList.substring(0, fieldList.length() - 1);
            }
        }
        if (fieldList == null) {
            throw new InvalidInputException("No field was specified for Field Required validator");
        }
        String[] fields = fieldList.split(",");
        Issue issue = this.getIssue();
        Issue originalissue = this.getOriginalIssue();
        for (String fieldKey : fields) {
            Field field = this.workflowUtils.getFieldFromKey(fieldKey);
            if (this.fieldCollectionsUtils.isIssueHasField(issue, field)) {
                Object fieldValue;
                if ("comment".equals(field.getId())) {
                    fieldValue = this.getTransitionComment();
                } else if ("attachment".equals(field.getId())) {
                    try {
                        fieldValue = ((List)((ModifiedValue)((MutableIssue)issue).getModifiedFields().get("attachment")).getNewValue()).get(0);
                    }
                    catch (Exception e) {
                        fieldValue = null;
                    }
                } else if ("timespent".equals(field.getId())) {
                    try {
                        fieldValue = ((ModifiedValue)((MutableIssue)issue).getModifiedFields().get("worklog")).getNewValue();
                    }
                    catch (Exception e) {
                        fieldValue = null;
                    }
                } else if ("issuelinks".equals(field.getId())) {
                    if (issue.getId() == null && issue.getKey() != null) {
                        return;
                    }
                    try {
                        fieldValue = ((IssueLinksSystemField.IssueLinkingValue)((ModifiedValue)((MutableIssue)issue).getModifiedFields().get("issuelinks")).getNewValue()).getValidationResult().getLinkKeys();
                    }
                    catch (Exception e) {
                        fieldValue = null;
                    }
                } else if ("versions".equals(field.getId())) {
                    Collection originalAffectedVersions = originalissue != null ? originalissue.getAffectedVersions() : new ArrayList();
                    fieldValue = this.getVersionsWithArchived(issue, field, originalAffectedVersions);
                } else if ("fixVersions".equals(field.getId())) {
                    Collection originalFixVersions = originalissue != null ? originalissue.getFixVersions() : new ArrayList();
                    fieldValue = this.getVersionsWithArchived(issue, field, originalFixVersions);
                } else {
                    fieldValue = this.workflowUtils.getFieldValueFromIssue(issue, field, true);
                }
                if (fieldValue != null && fieldValue.getClass().getName().equals("com.tempoplugin.accounts.account.api.Account")) {
                    try {
                        Method getId = fieldValue.getClass().getMethod("getId", new Class[0]);
                        if (getId.invoke(fieldValue, new Object[0]).equals(-1)) {
                            fieldValue = null;
                        }
                    }
                    catch (NoSuchMethodException getId) {
                    }
                    catch (InvocationTargetException getId) {
                    }
                    catch (IllegalAccessException getId) {
                        // empty catch block
                    }
                }
                if (fieldValue != null && (!(fieldValue instanceof Collection) || ((Collection)fieldValue).size() != 0)) continue;
                I18nHelper i18nh = this.beanFactory.getInstance(this.jiraAuthenticationContext.getUser());
                String msg1 = this.errorMsg != null && !this.errorMsg.trim().isEmpty() ? this.errorMsg : i18nh.getText("fieldrequiredvalidator.withfield", field.getName());
                String msg2 = this.errorMsg != null && !this.errorMsg.trim().isEmpty() ? this.errorMsg : i18nh.getText("fieldsrequiredvalidator.field_not_present", field.getName());
                this.setExceptionMessage(field, msg1, msg2);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug(issue.getKey() != null ? issue.getKey() : "<New Issue>: Field '" + field.getName() + " - " + field.getId() + "' is not assigned for the issue");
        }
    }

    private Collection getVersionsWithArchived(Issue issue, Field field, Collection alreadySelectedVersions) {
        Collection archived = this.versionManager.getVersionsArchived(issue.getProjectObject());
        archived.retainAll(alreadySelectedVersions);
        Object selected = this.workflowUtils.getFieldValueFromIssue(issue, field, false);
        if (selected != null) {
            archived.addAll((Collection)selected);
        }
        return archived.isEmpty() ? null : archived;
    }
}

