/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.annotation.Argument;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.validators.GenericValidator;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class FieldHasSingleValueValidator
extends GenericValidator {
    private final I18nResolver i18nResolver;
    @Argument(value="fieldKey")
    private String fieldKey;
    @Argument(value="jira.excludingSubtasks")
    private String excludingSubtasks;

    public FieldHasSingleValueValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, I18nResolver i18nResolver) {
        super(workflowUtils, fieldCollectionsUtils, licenseManager);
        this.i18nResolver = i18nResolver;
    }

    @Override
    protected void doValidate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException, WorkflowException {
        Field field = this.workflowUtils.getFieldFromKey(this.fieldKey);
        Issue issue = this.getIssue();
        Object value = this.workflowUtils.getFieldValueFromIssue(issue, field, false);
        if (value instanceof Collection && this.fieldCollectionsUtils.isIssueHasField(issue, field) && ((Collection)value).size() > 1) {
            if (this.excludingSubtasks != null && this.excludingSubtasks.equals("yes")) {
                HashSet values = new HashSet((Collection)value);
                for (Object subtask : issue.getSubTaskObjects()) {
                    Object subtaskValue;
                    if (!this.fieldCollectionsUtils.isIssueHasField((Issue)subtask, field) || !((subtaskValue = this.workflowUtils.getFieldValueFromIssue((Issue)subtask, field, false)) instanceof Collection)) continue;
                    values.removeAll((Collection)subtaskValue);
                }
                if (values.size() > 1) {
                    this.setExceptionMessage(field, this.i18nResolver.getText("field.has.single.value.validator.msg.subtasks", new Serializable[]{field.getName()}), this.i18nResolver.getText("field.has.single.value.validator.longmsg.subtasks", new Serializable[]{field.getName()}));
                }
            } else {
                this.setExceptionMessage(field, this.i18nResolver.getText("field.has.single.value.validator.msg", new Serializable[]{field.getName()}), this.i18nResolver.getText("field.has.single.value.validator.longmsg", new Serializable[]{field.getName()}));
            }
        }
    }
}

