/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.annotation.Argument;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.validators.GenericValidator;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;
import java.io.Serializable;
import java.util.Map;

public class FieldChangedValidator
extends GenericValidator {
    @Argument(value="fieldKey")
    private String fieldKey;
    private final I18nResolver i18nResolver;

    public FieldChangedValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, I18nResolver i18nResolver) {
        super(workflowUtils, fieldCollectionsUtils, licenseManager);
        this.i18nResolver = i18nResolver;
    }

    @Override
    protected void doValidate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException, WorkflowException {
        Field field = this.workflowUtils.getFieldFromKey(this.fieldKey);
        Issue issue = this.getIssue();
        MutableIssue mu = null;
        if (issue instanceof MutableIssue) {
            mu = (MutableIssue)issue;
        }
        if (mu != null) {
            if (this.fieldKey.equals("timespent")) {
                this.fieldKey = "worklog";
            }
            ModifiedValue mv = (ModifiedValue)mu.getModifiedFields().get(this.fieldKey);
            if (this.fieldKey.equals("issuelinks")) {
                IssueLinksSystemField.IssueLinkingValue ilv;
                if (mv == null) {
                    this.setExceptionMessage(field, this.i18nResolver.getText("field.changed.validator.message", new Serializable[]{field.getName()}), this.i18nResolver.getText("field.changed.validator.long.message", new Serializable[]{field.getName()}));
                } else if (mv.getNewValue() != null && mv.getNewValue() instanceof IssueLinksSystemField.IssueLinkingValue && (ilv = (IssueLinksSystemField.IssueLinkingValue)mv.getNewValue()).getValidationResult() == null) {
                    this.setExceptionMessage(field, this.i18nResolver.getText("field.changed.validator.message", new Serializable[]{field.getName()}), this.i18nResolver.getText("field.changed.validator.long.message", new Serializable[]{field.getName()}));
                }
            }
            if (mv == null || mv.getOldValue() == mv.getNewValue() || mv.getOldValue() != null && mv.getOldValue().equals(mv.getNewValue())) {
                this.setExceptionMessage(field, this.i18nResolver.getText("field.changed.validator.message", new Serializable[]{field.getName()}), this.i18nResolver.getText("field.changed.validator.long.message", new Serializable[]{field.getName()}));
            }
        }
    }
}

