/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.annotation.Argument;
import com.googlecode.jsu.annotation.TransientVariable;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.validators.GenericValidator;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowContext;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CommentRequiredValidator
extends GenericValidator {
    @TransientVariable(value="comment")
    private String strComment;
    @Argument(value="errorMessage")
    private String errorMsg;
    @Argument(value="hidGroupsList")
    private String strGroupsSelected;
    @TransientVariable(value="context")
    private WorkflowContext context;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final I18nResolver i18nResolver;
    private final FieldManager fieldManager;

    public CommentRequiredValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, UserManager userManager, GroupManager groupManager, ThirdPartyPluginLicenseStorageManager licenseManager, I18nResolver i18nResolver, FieldManager fieldManager) {
        super(workflowUtils, fieldCollectionsUtils, licenseManager);
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.i18nResolver = i18nResolver;
        this.fieldManager = fieldManager;
    }

    @Override
    protected void doValidate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException, WorkflowException {
        if (!TextUtils.stringSet((String)this.strComment)) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StackTraceElement[] stack = e.getStackTrace();
                for (StackTraceElement entry : stack) {
                    if (!entry.getClassName().equals("com.atlassian.jira.rpc.soap.JiraSoapServiceImpl") || !entry.getMethodName().equals("progressWorkflowAction")) continue;
                    return;
                }
                ApplicationUser userLogged = WorkflowUtil.getCallerUser((Map)transientVars);
                List<Group> groupsSelected = this.strGroupsSelected == null ? Collections.emptyList() : this.workflowUtils.getGroups(this.strGroupsSelected, "@@");
                for (Group group : groupsSelected) {
                    if (group == null || group.getName() == null || group.getName().isEmpty() || !this.groupManager.isUserInGroup(userLogged.getUsername(), group.getName())) continue;
                    return;
                }
                Field field = this.fieldManager.getField("comment");
                if ("".equals(this.errorMsg)) {
                    this.setExceptionMessage(field, this.i18nResolver.getText("comment.required.message"), this.i18nResolver.getText("comment.required.message.details"));
                }
                this.setExceptionMessage(field, this.errorMsg, this.i18nResolver.getText("comment.required.message.details"));
            }
        }
    }
}

