/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.MapUtils;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowSetIssueSecurityFromRoleFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    private Logger log = LoggerFactory.getLogger(WorkflowSetIssueSecurityFromRoleFunction.class);
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;

    protected WorkflowSetIssueSecurityFromRoleFunction(ThirdPartyPluginLicenseStorageManager licenseManager, IssueSecurityLevelManager issueSecurityLevelManager, IssueSecuritySchemeManager issueSecuritySchemeManager) {
        super(licenseManager);
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        HashMap<String, String> projectRoleMap = new HashMap<String, String>();
        ProjectRoleManager projectRoleManager = (ProjectRoleManager)ComponentManager.getComponentInstanceOfType(ProjectRoleManager.class);
        for (Object role : projectRoleManager.getProjectRoles()) {
            ProjectRole projectRole = (ProjectRole)role;
            projectRoleMap.put(projectRole.getId().toString(), projectRole.getName());
        }
        velocityParams.put("projectroles", MapUtils.sortByValue(projectRoleMap));
        LinkedHashMap securityLevelsMap = new LinkedHashMap();
        for (Scheme scheme : this.issueSecuritySchemeManager.getSchemeObjects()) {
            HashMap<String, String> tempMap = new HashMap<String, String>();
            for (IssueSecurityLevel securityLevel : this.issueSecurityLevelManager.getIssueSecurityLevels(scheme.getId().longValue())) {
                tempMap.put(securityLevel.getId().toString(), securityLevel.getName() + " (" + scheme.getName() + ")");
            }
            securityLevelsMap.putAll(MapUtils.sortByValue(tempMap));
        }
        securityLevelsMap.put("none", "None");
        velocityParams.put("securitylevels", securityLevelsMap);
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        ProjectRoleManager projectRoleManager;
        ProjectRole projectRole;
        velocityParams.put("selectedProjectRoleId", ((FunctionDescriptor)descriptor).getArgs().get("projectrole.id"));
        velocityParams.put("selectedSecurityLevelId", ((FunctionDescriptor)descriptor).getArgs().get("security.id"));
        if (velocityParams.get("selectedProjectRoleId") != null && (projectRole = (projectRoleManager = (ProjectRoleManager)ComponentManager.getComponentInstanceOfType(ProjectRoleManager.class)).getProjectRole(new Long((String)velocityParams.get("selectedProjectRoleId")))) != null) {
            velocityParams.put("selectedProjectRoleName", projectRole.getName());
        }
        if (velocityParams.get("selectedSecurityLevelId") != null) {
            if (velocityParams.get("selectedSecurityLevelId").equals("none")) {
                velocityParams.put("selectedSecurityLevelName", "none");
            } else {
                try {
                    IssueSecurityLevel securityLevel = this.issueSecurityLevelManager.getSecurityLevel(new Long((String)velocityParams.get("selectedSecurityLevelId")).longValue());
                    if (securityLevel != null) {
                        velocityParams.put("selectedSecurityLevelName", securityLevel.getName() + " (" + this.issueSecuritySchemeManager.getSchemeObject(securityLevel.getSchemeId()).getName() + ")");
                    }
                }
                catch (NumberFormatException e) {
                    this.log.error("Invalid security level ID", (Throwable)e);
                }
            }
        }
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map functionParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put("projectrole.id", this.extractSingleParam(functionParams, "selectedProjectRoleId"));
            params.put("security.id", this.extractSingleParam(functionParams, "selectedSecurityLevelId"));
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        params.putAll(super.getDescriptorParams(functionParams));
        return params;
    }
}

