/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class Utils {
    private static JiraWorkflow getWorkflow(Issue issue) {
        WorkflowManager wm = ComponentAccessor.getWorkflowManager();
        return wm.getWorkflow(issue);
    }

    public static ActionDescriptor transitionFromName(Issue issue, String name) {
        JiraWorkflow workflow = Utils.getWorkflow(issue);
        StepDescriptor linkedStep = workflow.getLinkedStep(issue.getStatusObject());
        List actions = linkedStep.getActions();
        for (ActionDescriptor ad : actions) {
            if (!ad.getName().equals(name)) continue;
            return ad;
        }
        List actionsIds = linkedStep.getCommonActions();
        WorkflowDescriptor workflowDescriptor = workflow.getDescriptor();
        Map commonActions = workflowDescriptor.getCommonActions();
        for (Integer id : actionsIds) {
            ActionDescriptor ad = (ActionDescriptor)commonActions.get(id);
            if (!ad.getName().equals(name)) continue;
            return ad;
        }
        actions = workflowDescriptor.getGlobalActions();
        for (ActionDescriptor ad : actions) {
            if (!ad.getName().equals(name)) continue;
            return ad;
        }
        return null;
    }

    public static ActionDescriptor transitionFromId(Issue issue, int id) {
        JiraWorkflow workflow = Utils.getWorkflow(issue);
        StepDescriptor linkedStep = workflow.getLinkedStep(issue.getStatusObject());
        List actions = linkedStep.getActions();
        for (ActionDescriptor ad : actions) {
            if (ad.getId() != id) continue;
            return ad;
        }
        List actionsIds = linkedStep.getCommonActions();
        WorkflowDescriptor workflowDescriptor = workflow.getDescriptor();
        Map commonActions = workflowDescriptor.getCommonActions();
        for (Integer actionsId : actionsIds) {
            if (actionsId != id) continue;
            return (ActionDescriptor)commonActions.get(id);
        }
        actions = workflowDescriptor.getGlobalActions();
        for (ActionDescriptor ad : actions) {
            if (ad.getId() != id) continue;
            return ad;
        }
        return null;
    }

    public static void printAnyErrors(Issue issue, ErrorCollection errorCollection, Logger logger) {
        if (errorCollection.hasAnyErrors()) {
            logger.warn("Field validation error transitioning issue " + issue.getKey() + ":");
            for (String errMsg : errorCollection.getErrorMessages()) {
                logger.warn("\t" + errMsg);
            }
            for (String fieldName : errorCollection.getErrors().keySet()) {
                logger.warn("\tField " + fieldName + ": " + (String)errorCollection.getErrors().get(fieldName));
            }
        }
    }

    public static String printAnyErrors(Issue issue, ErrorCollection errorCollection) {
        StringBuilder sb = new StringBuilder();
        if (errorCollection.hasAnyErrors()) {
            sb.append("Field validation error transitioning issue " + issue.getKey() + ":\n");
            for (String errMsg : errorCollection.getErrorMessages()) {
                sb.append("\t" + errMsg + "\n");
            }
            for (String fieldName : errorCollection.getErrors().keySet()) {
                sb.append("\tField " + fieldName + ": " + (String)errorCollection.getErrors().get(fieldName) + "\n");
            }
        }
        return sb.toString();
    }

    public static String encodeTemplate(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("\\$\\{", "\\$\u2063{");
    }

    public static String decodeTemplate(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("\\$\u2063\\{", "\\${");
    }
}

