/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UnlinkIssuesFunction
extends AbstractPreserveChangesPostFunction {
    private final FieldValueService fieldValueService;
    private final IssueLinkManager issueLinkManager;
    private final UserManager userManager;
    private final ScriptManager scriptManager;

    public UnlinkIssuesFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, PreferencesService preferencesService, FieldValueService fieldValueService, IssueLinkManager issueLinkManager, UserManager userManager, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.fieldValueService = fieldValueService;
        this.issueLinkManager = issueLinkManager;
        this.userManager = userManager;
        this.scriptManager = scriptManager;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        Object res;
        GroovyExpression expression;
        String groovyExpression = Utils.decodeTemplate((String)args.get("groovyExpression"));
        MutableIssue issue = this.getIssue(transientVars);
        ApplicationUser runAsUser = this.getCallerUser(transientVars, args);
        if (StringUtils.isNotBlank((CharSequence)args.get("runAsUser"))) {
            runAsUser = this.userManager.getUserByNameEvenWhenUnknown((String)args.get("runAsUser"));
        }
        for (IssueLink issueLink : this.issueLinkManager.getOutwardLinks(issue.getId())) {
            if (issueLink.isSystemLink()) continue;
            expression = new GroovyExpression(groovyExpression, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            expression.addIssueVariable("linkedIssue", issueLink.getDestinationObject());
            expression.addVariable("linkTypeName", issueLink.getIssueLinkType().getOutward());
            res = expression.eval(this.workflowUtils, this.fieldValueService);
            if (res == null || res instanceof Boolean && !((Boolean)res).booleanValue()) continue;
            this.removeIssueLink(issueLink, runAsUser);
        }
        for (IssueLink issueLink : this.issueLinkManager.getInwardLinks(issue.getId())) {
            if (issueLink.isSystemLink()) continue;
            expression = new GroovyExpression(groovyExpression, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            expression.addIssueVariable("linkedIssue", issueLink.getSourceObject());
            expression.addVariable("linkTypeName", issueLink.getIssueLinkType().getInward());
            res = expression.eval(this.workflowUtils, this.fieldValueService);
            if (res == null || res instanceof Boolean && !((Boolean)res).booleanValue()) continue;
            this.removeIssueLink(issueLink, runAsUser);
        }
    }

    private void removeIssueLink(IssueLink issueLink, ApplicationUser user) {
        try {
            Method removeIssueLink = this.issueLinkManager.getClass().getMethod("removeIssueLink", IssueLink.class, ApplicationUser.class);
            removeIssueLink.invoke((Object)this.issueLinkManager, issueLink, user);
        }
        catch (NoSuchMethodException e) {
            try {
                Method removeIssueLink = this.issueLinkManager.getClass().getMethod("removeIssueLink", IssueLink.class, User.class);
                removeIssueLink.invoke((Object)this.issueLinkManager, issueLink, UserCompatibilityHelper.getUserForKey(user.getKey()));
            }
            catch (Exception e1) {
                throw new IllegalStateException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

