/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionParentIssueFunction
extends AbstractPreserveChangesPostFunction {
    private Logger log = LoggerFactory.getLogger(TransitionParentIssueFunction.class);
    public static final String TRANSITION = "transition";
    private final IssueWorkflowManager issueWorkflowManager;
    private final FieldValueService fieldValueService;
    private final UserManager userManager;

    public TransitionParentIssueFunction(ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, WorkflowUtils workflowUtils, IssueWorkflowManager issueWorkflowManager, FieldValueService fieldValueService, UserManager userManager, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.issueWorkflowManager = issueWorkflowManager;
        this.fieldValueService = fieldValueService;
        this.userManager = userManager;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        MutableIssue issue = this.getIssue(transientVars);
        String transitionName = (String)args.get(TRANSITION);
        MutableIssue parentIssue = (MutableIssue)issue.getParentObject();
        if (parentIssue != null) {
            ActionDescriptor transition;
            GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
            if (groovyExpression != null && !((Boolean)groovyExpression.addIssueVariable("parentIssue", (Issue)parentIssue).eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
                return;
            }
            try {
                Integer transitionId = Integer.parseInt(transitionName);
                transition = Utils.transitionFromId((Issue)parentIssue, transitionId);
            }
            catch (NumberFormatException e) {
                transition = Utils.transitionFromName((Issue)parentIssue, transitionName);
            }
            if (transition == null) {
                this.log.warn("Error while executing function : transition [" + transitionName + "] not found");
                return;
            }
            ApplicationUser runAsUser = this.getCallerUser(transientVars, args);
            if (StringUtils.isNotBlank((CharSequence)args.get("runAsUser"))) {
                runAsUser = this.userManager.getUserByNameEvenWhenUnknown((String)args.get("runAsUser"));
            }
            if (this.issueWorkflowManager.isValidAction((Issue)parentIssue, transition.getId(), runAsUser)) {
                WorkflowTransitionUtil workflowTransitionUtil = (WorkflowTransitionUtil)JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
                workflowTransitionUtil.setIssue(parentIssue);
                workflowTransitionUtil.setUserkey(runAsUser.getKey());
                workflowTransitionUtil.setAction(transition.getId());
                ErrorCollection errorCollection = workflowTransitionUtil.validate();
                Utils.printAnyErrors((Issue)parentIssue, errorCollection, this.log);
                if (!errorCollection.hasAnyErrors()) {
                    errorCollection = workflowTransitionUtil.progress();
                    Utils.printAnyErrors((Issue)parentIssue, errorCollection, this.log);
                    if (!errorCollection.hasAnyErrors()) {
                        this.indexIssue((Issue)parentIssue);
                    } else if (this.preferencesService.isThrowExceptions().booleanValue()) {
                        throw new WorkflowException("Error during transition execution: " + Utils.printAnyErrors((Issue)parentIssue, errorCollection));
                    }
                } else if (this.preferencesService.isThrowExceptions().booleanValue()) {
                    throw new WorkflowException("Transition validation error(s): " + Utils.printAnyErrors((Issue)parentIssue, errorCollection));
                }
            } else {
                this.log.info("Transition " + transitionName + " is not valid on issue " + parentIssue.getKey() + " for user " + runAsUser + ". Skipping.");
            }
        }
    }
}

