/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionLinkedIssuesFunction
extends AbstractPreserveChangesPostFunction {
    private Logger log = LoggerFactory.getLogger(TransitionLinkedIssuesFunction.class);
    private final IssueLinkManager issueLinkManager;
    private final UserManager userManager;
    private final IssueWorkflowManager issueWorkflowManager;
    private final FieldValueService fieldValueService;

    public TransitionLinkedIssuesFunction(ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, IssueLinkManager issueLinkManager, WorkflowUtils workflowUtils, UserManager userManager, IssueWorkflowManager issueWorkflowManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.issueLinkManager = issueLinkManager;
        this.userManager = userManager;
        this.issueWorkflowManager = issueWorkflowManager;
        this.fieldValueService = fieldValueService;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        Long linkTypeId;
        MutableIssue issue = this.getIssue(transientVars);
        String transitionName = (String)args.get("transition");
        String rawLinkType = (String)args.get("selectedLinkType");
        if (StringUtils.isBlank(rawLinkType) || rawLinkType.split(":").length != 2) {
            this.log.warn("TransitionLinkedIssuesFunction is not configured with a valid link type ID.");
            return;
        }
        boolean isInwardLink = rawLinkType.split(":")[0].equalsIgnoreCase("inward");
        try {
            linkTypeId = new Long(Long.parseLong(rawLinkType.split(":")[1]));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("TransitionLinkedIssuesFunction not configured with a valid link type ID: ").append(rawLinkType).append(" can not be parsed.").toString());
        }
        ApplicationUser runAsUser = this.getCallerUser(transientVars, args);
        if (StringUtils.isNotBlank((CharSequence)args.get("runAsUser"))) {
            runAsUser = this.userManager.getUserByNameEvenWhenUnknown((String)args.get("runAsUser"));
        }
        List links = isInwardLink ? this.issueLinkManager.getInwardLinks(issue.getId()) : this.issueLinkManager.getOutwardLinks(issue.getId());
        for (IssueLink issueLink : links) {
            ActionDescriptor transition;
            if (!issueLink.getLinkTypeId().equals(linkTypeId)) continue;
            Issue linkedIssue = isInwardLink ? issueLink.getSourceObject() : issueLink.getDestinationObject();
            GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
            if (groovyExpression != null && !((Boolean)groovyExpression.addIssueVariable("linkedIssue", linkedIssue).eval(this.workflowUtils, this.fieldValueService)).booleanValue()) continue;
            try {
                Integer transitionId = Integer.parseInt(transitionName);
                transition = Utils.transitionFromId(linkedIssue, transitionId);
            }
            catch (NumberFormatException e) {
                transition = Utils.transitionFromName(linkedIssue, transitionName);
            }
            if (transition == null) {
                this.log.info("Error while triggering transition [" + transitionName + "] on issue " + linkedIssue.getKey() + ": transition not found");
                continue;
            }
            if (this.issueWorkflowManager.isValidAction(linkedIssue, transition.getId(), runAsUser)) {
                WorkflowTransitionUtil workflowTransitionUtil = (WorkflowTransitionUtil)JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
                workflowTransitionUtil.setIssue((MutableIssue)linkedIssue);
                workflowTransitionUtil.setUserkey(runAsUser.getKey());
                workflowTransitionUtil.setAction(transition.getId());
                ErrorCollection errorCollection = workflowTransitionUtil.validate();
                Utils.printAnyErrors(linkedIssue, errorCollection, this.log);
                if (!errorCollection.hasAnyErrors()) {
                    try {
                        errorCollection = workflowTransitionUtil.progress();
                        Utils.printAnyErrors(linkedIssue, errorCollection, this.log);
                        if (!errorCollection.hasAnyErrors()) {
                            this.indexIssue(linkedIssue);
                            continue;
                        }
                        if (!this.preferencesService.isThrowExceptions().booleanValue()) continue;
                        throw new WorkflowException("Error during transition execution: " + Utils.printAnyErrors(linkedIssue, errorCollection));
                    }
                    catch (Exception e) {
                        this.log.warn("Error while triggering transition [" + transitionName + "] on issue " + linkedIssue.getKey() + ": " + e.getMessage());
                        if (!this.preferencesService.isThrowExceptions().booleanValue()) continue;
                        throw e;
                    }
                }
                if (!this.preferencesService.isThrowExceptions().booleanValue()) continue;
                throw new WorkflowException("Transition validation error(s): " + Utils.printAnyErrors(linkedIssue, errorCollection));
            }
            this.log.info("Transition " + transitionName + " is not valid on issue " + linkedIssue.getKey() + " for user " + runAsUser + ". Skipping.");
        }
    }
}

