/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitionIssueFunction
extends AbstractPreserveChangesPostFunction {
    private Logger log = LoggerFactory.getLogger(TransitionIssueFunction.class);
    public static final String TRANSITION = "transition";
    private final ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory;
    private final IssueWorkflowManager issueWorkflowManager;
    private final UserManager userManager;
    private final FieldValueService fieldValueService;

    public TransitionIssueFunction(ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, WorkflowUtils workflowUtils, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, IssueWorkflowManager issueWorkflowManager, UserManager userManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.threadLocalDelegateExecutorFactory = threadLocalDelegateExecutorFactory;
        this.issueWorkflowManager = issueWorkflowManager;
        this.userManager = userManager;
        this.fieldValueService = fieldValueService;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        WorkflowDescriptor wd;
        ActionDescriptor transition;
        MutableIssue issue = this.getIssue(transientVars);
        String transitionName = (String)args.get(TRANSITION);
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            this.log.debug("Skipping Transition Issue post-function because condition script returned false");
            return;
        }
        try {
            Integer transitionId = Integer.parseInt(transitionName);
            transition = Utils.transitionFromId((Issue)issue, transitionId);
        }
        catch (NumberFormatException e) {
            transition = Utils.transitionFromName((Issue)issue, transitionName);
        }
        if (transition == null) {
            this.log.warn("Error while executing function : transition [" + transitionName + "] not found");
            return;
        }
        ApplicationUser runAsUser = this.getCallerUser(transientVars, args);
        if (StringUtils.isNotBlank((CharSequence)args.get("runAsUser"))) {
            runAsUser = this.userManager.getUserByNameEvenWhenUnknown((String)args.get("runAsUser"));
        }
        if ((wd = (WorkflowDescriptor)transientVars.get("descriptor")).getInitialAction(((Integer)transientVars.get("actionId")).intValue()) != null) {
            this.log.debug("Starting transition thread (because Transition Issue is being called from the Create transition)");
            Runnable runner = new Runner(issue.getId(), transitionName, runAsUser.getKey());
            runner = this.threadLocalDelegateExecutorFactory.createRunnable(runner);
            Thread t = new Thread(runner);
            t.start();
        } else if (this.issueWorkflowManager.isValidAction((Issue)issue, transition.getId(), runAsUser)) {
            WorkflowTransitionUtil workflowTransitionUtil = (WorkflowTransitionUtil)JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
            workflowTransitionUtil.setIssue(issue);
            workflowTransitionUtil.setUserkey(runAsUser.getKey());
            workflowTransitionUtil.setAction(transition.getId());
            ErrorCollection errorCollection = workflowTransitionUtil.validate();
            Utils.printAnyErrors((Issue)issue, errorCollection, this.log);
            if (!errorCollection.hasAnyErrors()) {
                this.log.debug("Transitioning issue");
                errorCollection = workflowTransitionUtil.progress();
                Utils.printAnyErrors((Issue)issue, errorCollection, this.log);
                if (!errorCollection.hasAnyErrors()) {
                    this.indexIssue((Issue)issue);
                } else if (this.preferencesService.isThrowExceptions().booleanValue()) {
                    throw new WorkflowException("Error during transition execution: " + Utils.printAnyErrors((Issue)issue, errorCollection));
                }
            } else if (this.preferencesService.isThrowExceptions().booleanValue()) {
                throw new WorkflowException("Transition validation error(s): " + Utils.printAnyErrors((Issue)issue, errorCollection));
            }
        } else {
            this.log.info("Transition " + transitionName + " is not valid on issue " + issue.getKey() + " for user " + runAsUser + ". Skipping.");
        }
    }

    private class Runner
    implements Runnable {
        private Long issueId;
        private final String transitionName;
        private final String userKey;

        public Runner(Long issueId, String transitionName, String userKey) {
            this.issueId = issueId;
            this.transitionName = transitionName;
            this.userKey = userKey;
        }

        @Override
        public void run() {
            ActionDescriptor transition;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MutableIssue mutableIssue = TransitionIssueFunction.this.issueManager.getIssueObject(this.issueId);
            try {
                Integer transitionId = Integer.parseInt(this.transitionName);
                transition = Utils.transitionFromId((Issue)mutableIssue, transitionId);
            }
            catch (NumberFormatException e) {
                transition = Utils.transitionFromName((Issue)mutableIssue, this.transitionName);
            }
            if (transition == null) {
                TransitionIssueFunction.this.log.warn("Error while executing function : transition [" + this.transitionName + "] not found");
                return;
            }
            ApplicationUser user = TransitionIssueFunction.this.userManager.getUserByKey(this.userKey);
            if (TransitionIssueFunction.this.issueWorkflowManager.isValidAction((Issue)mutableIssue, transition.getId(), user)) {
                WorkflowTransitionUtil workflowTransitionUtil = (WorkflowTransitionUtil)JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
                workflowTransitionUtil.setIssue(mutableIssue);
                workflowTransitionUtil.setUserkey(this.userKey);
                workflowTransitionUtil.setAction(transition.getId());
                ErrorCollection errorCollection = workflowTransitionUtil.validate();
                Utils.printAnyErrors((Issue)mutableIssue, errorCollection, TransitionIssueFunction.this.log);
                if (!errorCollection.hasAnyErrors()) {
                    errorCollection = workflowTransitionUtil.progress();
                    Utils.printAnyErrors((Issue)mutableIssue, errorCollection, TransitionIssueFunction.this.log);
                    if (!errorCollection.hasAnyErrors()) {
                        TransitionIssueFunction.this.indexIssue((Issue)mutableIssue);
                    }
                } else {
                    TransitionIssueFunction.this.log.info("Transition " + this.transitionName + " is not valid on issue " + mutableIssue.getKey() + " for user " + user + ". Skipping.");
                }
            }
        }
    }
}

