/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetIssueSecurityFromRoleFunction
extends AbstractPreserveChangesPostFunction {
    private static final Logger log = LoggerFactory.getLogger(SetIssueSecurityFromRoleFunction.class);
    private final ProjectRoleManager projectRoleManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final FieldValueService fieldValueService;

    protected SetIssueSecurityFromRoleFunction(ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, WorkflowUtils workflowUtils, ProjectRoleManager projectRoleManager, IssueSecurityLevelManager issueSecurityLevelManager, IssueSecuritySchemeManager issueSecuritySchemeManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.projectRoleManager = projectRoleManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.fieldValueService = fieldValueService;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder issueChangeHolder) throws WorkflowException {
        MutableIssue issue = this.getIssue(transientVars);
        String rawprojectRoleId = (String)args.get("projectrole.id");
        String rawissueSecurityId = (String)args.get("security.id");
        Long projectRoleId = null;
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            return;
        }
        if (StringUtils.isBlank(rawprojectRoleId)) {
            throw new IllegalArgumentException("SetIssueSecurityFromRole not configured with a valid projectroleid.");
        }
        try {
            projectRoleId = new Long(Long.parseLong(rawprojectRoleId));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("SetIssueSecurityFromRole not configured with a valid projectroleid, the project role id: ").append(projectRoleId).append(" can not be parsed.").toString());
        }
        ProjectRole projectRole = this.projectRoleManager.getProjectRole(projectRoleId);
        if (projectRole == null) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("SetIssueSecurityFromRole is configured with a project role that doesn't exist: id is ").append(projectRoleId).toString());
        }
        ApplicationUser curUser = this.getCallerUser(transientVars, args);
        if (curUser == null) {
            return;
        }
        Project project = issue.getProjectObject();
        ProjectRoleActors roleActors = this.projectRoleManager.getProjectRoleActors(projectRole, project);
        if (roleActors != null && roleActors.contains(curUser)) {
            if (StringUtils.isBlank(rawissueSecurityId)) {
                throw new IllegalArgumentException("SetIssueSecurityFromRole not configured with a valid issueSecurityId.");
            }
            Long issueSecurityId = null;
            if (!rawissueSecurityId.equals("none")) {
                try {
                    issueSecurityId = new Long(Long.parseLong(rawissueSecurityId));
                    IssueSecurityLevel securityLevel = this.issueSecurityLevelManager.getSecurityLevel(issueSecurityId.longValue());
                    Scheme projectISScheme = this.issueSecuritySchemeManager.getSchemeFor(issue.getProjectObject());
                    if (projectISScheme == null || !securityLevel.getSchemeId().equals(projectISScheme.getId())) {
                        StringBuffer sb = new StringBuffer();
                        log.warn(sb.append("SetIssueSecurityFromRole configured with an issueSecurityId that is not valid for the current issue. Issue security id: ").append(issueSecurityId).toString());
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    StringBuffer sb = new StringBuffer();
                    throw new IllegalArgumentException(sb.append("SetIssueSecurityFromRole not configured with a valid issueSecurityId, the issue security id: ").append(issueSecurityId).append(" can not be parsed.").toString());
                }
            }
            try {
                issue.setSecurityLevelId(issueSecurityId);
            }
            catch (NoSuchMethodError err) {
                GenericValue securityLevelGV = null;
                try {
                    securityLevelGV = this.issueSecurityLevelManager.getIssueSecurityLevel(issueSecurityId);
                }
                catch (GenericEntityException e) {
                    throw new IllegalArgumentException("Invalid SecurityLevel ID '" + issueSecurityId + "'.");
                }
                if (securityLevelGV == null) {
                    throw new IllegalArgumentException("Invalid SecurityLevel ID '" + issueSecurityId + "'.");
                }
                issue.setSecurityLevel(securityLevelGV);
            }
            if (this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) {
                this.updateIssue(issue, issueChangeHolder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
            }
        }
    }
}

