/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collection;
import java.util.Map;

public class SetFieldFromUserPropFunction
extends AbstractPreserveChangesPostFunction {
    private final FieldValueService fieldValueService;
    private final UserPropertyManager userPropertyManager;

    public SetFieldFromUserPropFunction(WorkflowUtils workflowUtils, UserPropertyManager userPropertyManager, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.userPropertyManager = userPropertyManager;
        this.fieldValueService = fieldValueService;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        String sourcePropKey = (String)args.get("user.property.key");
        ApplicationUser curUser = this.getCallerUser(transientVars, args);
        if (curUser == null) {
            return;
        }
        if (!this.userPropertyManager.getPropertySet(curUser).exists("jira.meta." + sourcePropKey)) {
            this.log.info(String.format("Unable to find user property [%s] on current user", sourcePropKey));
            return;
        }
        String value = this.userPropertyManager.getPropertySet(curUser).getString("jira.meta." + sourcePropKey);
        String sourceFieldKey = (String)args.get("field");
        Field field = this.workflowUtils.getFieldFromKey(sourceFieldKey);
        if (field == null) {
            throw new WorkflowException(String.format("Unable to find field with key [%s]", sourceFieldKey));
        }
        MutableIssue issue = this.getIssue(transientVars);
        Object currentValue = this.fieldValueService.getFieldValueFromIssue((Issue)issue, field, false);
        if (!(!"yes".equals(args.get("copyOnlyIfNotSet")) || currentValue == null || currentValue instanceof Collection && ((Collection)currentValue).isEmpty())) {
            return;
        }
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            return;
        }
        this.fieldValueService.setFieldValue(issue, field, new FieldValueHolder(value), null, (IssueChangeHolder)holder, false);
        if (this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) {
            this.updateIssue(issue, holder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Set field %s to [%s]", sourceFieldKey, value));
        }
    }
}

