/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.google.common.collect.ImmutableMap;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class EmailIssueFunction
extends AbstractPreserveChangesPostFunction {
    private final FieldValueService fieldValueService;
    private final AdhocNotificationService adhocNotificationService;
    private final UserManager userManager;
    private final ProjectRoleManager projectRoleManager;
    private final ScriptManager scriptManager;

    public EmailIssueFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, PreferencesService preferencesService, FieldValueService fieldValueService, AdhocNotificationService adhocNotificationService, UserManager userManager, ProjectRoleManager projectRoleManager, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.fieldValueService = fieldValueService;
        this.adhocNotificationService = adhocNotificationService;
        this.userManager = userManager;
        this.projectRoleManager = projectRoleManager;
        this.scriptManager = scriptManager;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        AdhocNotificationService.ValidateNotificationResult result;
        String toUsersScript;
        String toUserFields;
        String toUsers;
        String textBody;
        String htmlBody;
        String subject;
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            return;
        }
        MutableIssue issue = this.getIssue(transientVars);
        ApplicationUser runAsUser = this.getCallerUser(transientVars, args);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)args.get("runAsUser"))) {
            runAsUser = this.userManager.getUserByNameEvenWhenUnknown((String)args.get("runAsUser"));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(subject = Utils.decodeTemplate((String)args.get("subject")))) {
            GroovyExpression expression = new GroovyExpression(subject, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            subject = expression.evalTemplate(this.workflowUtils, this.fieldValueService);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(htmlBody = Utils.decodeTemplate((String)args.get("htmlBody")))) {
            GroovyExpression expression = new GroovyExpression(htmlBody, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            htmlBody = expression.evalTemplate(this.workflowUtils, this.fieldValueService);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(textBody = Utils.decodeTemplate((String)args.get("textBody")))) {
            GroovyExpression expression = new GroovyExpression(textBody, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            textBody = expression.evalTemplate(this.workflowUtils, this.fieldValueService);
        }
        NotificationBuilder notificationBuilder = this.adhocNotificationService.makeBuilder();
        notificationBuilder.setTemplate("issuenotify.vm").setTemplateParams(ImmutableMap.of((Object)"subject", (Object)StringUtils.defaultString((String)subject), (Object)"textBody", (Object)StringUtils.defaultString((String)textBody), (Object)"htmlBody", (Object)StringUtils.defaultString((String)htmlBody))).setToReporter("yes".equals(args.get("toReporter")) && issue.getReporterId() != null).setToAssignee("yes".equals(args.get("toAssignee")) && issue.getAssigneeId() != null).setToWatchers("yes".equals(args.get("toWatchers"))).setToVoters("yes".equals(args.get("toVoters")));
        String toGroups = (String)args.get("toGroups");
        if (org.apache.commons.lang3.StringUtils.isNotBlank(toGroups)) {
            notificationBuilder.addToGroups(Arrays.asList(toGroups.split(",")));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(toUsers = (String)args.get("toUsers"))) {
            notificationBuilder.addToUsers(Arrays.asList(toUsers.split(",")));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(toUserFields = (String)args.get("toUserFields"))) {
            String[] fieldKeys;
            for (String fieldKey : fieldKeys = toUserFields.split(",")) {
                FieldValueHolder val = this.fieldValueService.createFieldValueHolder((Issue)issue, fieldKey);
                notificationBuilder.addToUsers(val.getMultiStringValues(","));
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(toUsersScript = (String)args.get("toUsersScript"))) {
            GroovyExpression expression = new GroovyExpression(toUsersScript, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            FieldValueHolder result2 = this.fieldValueService.createFieldValueHolderFomGroovyResult(expression.eval(this.workflowUtils, this.fieldValueService), "assignee");
            notificationBuilder.addToUsers(result2.getMultiStringValues(","));
        }
        SimpleErrorCollection errors = new SimpleErrorCollection();
        String toRoleMembers = (String)args.get("toRoleMembers");
        if (org.apache.commons.lang3.StringUtils.isNotBlank(toRoleMembers)) {
            for (String roleId : toRoleMembers.split(",")) {
                try {
                    Long roleIdNum = Long.parseLong(roleId);
                    ProjectRole projectRole = this.projectRoleManager.getProjectRole(roleIdNum);
                    if (projectRole != null) {
                        ProjectRoleActors roleActors = this.projectRoleManager.getProjectRoleActors(projectRole, issue.getProjectObject());
                        for (ApplicationUser applicationUser : roleActors.getApplicationUsers()) {
                            notificationBuilder.addToUser(applicationUser.getUsername());
                        }
                        continue;
                    }
                    errors.addErrorMessage("No project role with ID: " + roleId);
                }
                catch (NumberFormatException e) {
                    errors.addErrorMessage("Invalid project role ID: " + roleId);
                }
            }
        }
        if (!(result = this.validateNotification(notificationBuilder, runAsUser, (Issue)issue, AdhocNotificationService.ValiationOption.CONTINUE_ON_NO_RECIPIENTS)).isValid()) {
            errors.addErrorCollection(result.getErrorCollection());
        }
        if (errors.hasAnyErrors()) {
            throw new IllegalArgumentException("Could not send notification email because of validation errors: " + errors.toString());
        }
        this.adhocNotificationService.sendNotification(result);
    }

    private AdhocNotificationService.ValidateNotificationResult validateNotification(NotificationBuilder notification, ApplicationUser from, Issue issue, AdhocNotificationService.ValiationOption option) {
        try {
            Method method = this.adhocNotificationService.getClass().getMethod("validateNotification", NotificationBuilder.class, ApplicationUser.class, Issue.class, AdhocNotificationService.ValiationOption.class);
            return (AdhocNotificationService.ValidateNotificationResult)method.invoke((Object)this.adhocNotificationService, notification, from, issue, option);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = this.adhocNotificationService.getClass().getMethod("validateNotification", NotificationBuilder.class, User.class, Issue.class, AdhocNotificationService.ValiationOption.class);
                return (AdhocNotificationService.ValidateNotificationResult)method.invoke((Object)this.adhocNotificationService, notification, UserCompatibilityHelper.getUserForKey(from.getKey()), issue, option);
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e1) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e1) {
                throw new IllegalStateException(e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

