/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.jmwe.plugins.functions.WorkflowCreateIssueFunction;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIssueFunction
extends AbstractPreserveChangesPostFunction {
    private Logger log = LoggerFactory.getLogger(CreateIssueFunction.class);
    private final CommentManager commentManager;
    private final IssueLinkManager issueLinkManager;
    private final UserManager userManager;
    private final IssueTypeManager issueTypeManager;
    private final IssueService issueService;
    private final ProjectManager projectManager;
    private final SubTaskManager subTaskManager;
    private final FieldManager fieldManager;
    private final FieldValueService fieldValueService;
    private final FieldCollectionsUtils fieldCollectionsUtils;
    private final ScriptManager scriptManager;

    public CreateIssueFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, CommentManager commentManager, IssueLinkManager issueLinkManager, UserManager userManager, IssueTypeManager issueTypeManager, IssueService issueService, ProjectManager projectManager, SubTaskManager subTaskManager, FieldManager fieldManager, FieldValueService fieldValueService, FieldCollectionsUtils fieldCollectionsUtils, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.commentManager = commentManager;
        this.issueLinkManager = issueLinkManager;
        this.userManager = userManager;
        this.issueTypeManager = issueTypeManager;
        this.issueService = issueService;
        this.projectManager = projectManager;
        this.subTaskManager = subTaskManager;
        this.fieldManager = fieldManager;
        this.fieldValueService = fieldValueService;
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.scriptManager = scriptManager;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        IssueService.CreateValidationResult createValidationResult;
        Long projectId;
        String rawLinkType;
        String projectKey = (String)args.get("projectKey");
        String calculatedProjectKey = Utils.decodeTemplate((String)args.get("calculatedProjectKey"));
        String issueTypeId = (String)args.get("issuetype");
        String parentIssueKeyType = (String)args.get("parentIssueType");
        String calculatedParentIssueKey = Utils.decodeTemplate((String)args.get("calculatedParentIssue"));
        String runAsUser = (String)args.get("runAsUser");
        String fieldsToSetJSON = Utils.decodeTemplate((String)args.get("fieldsToSet"));
        WorkflowCreateIssueFunction.FieldsToSet fieldsToSet = null;
        try {
            fieldsToSet = (WorkflowCreateIssueFunction.FieldsToSet)new ObjectMapper().readValue(fieldsToSetJSON, WorkflowCreateIssueFunction.FieldsToSet.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid fields to set option: " + fieldsToSetJSON, e);
        }
        boolean bCommentIssue = "yes".equals(args.get("commentIssue"));
        String commentType = (String)args.get("commentType");
        String commentStringOrScript = Utils.decodeTemplate((String)args.get("comment"));
        boolean bSendCommentNotification = "yes".equals(args.get("sendNotification"));
        String restrictToGroup = (String)args.get("restrictToGroup");
        if (StringUtils.isBlank(restrictToGroup)) {
            restrictToGroup = null;
        }
        String restrictToRoleIDStr = (String)args.get("restrictToProjectRole");
        Long restrictToRoleID = null;
        if (StringUtils.isNotBlank(restrictToRoleIDStr)) {
            restrictToRoleID = Long.parseLong(restrictToRoleIDStr);
        }
        boolean restrictToInternal = "yes".equalsIgnoreCase((String)args.get("restrictToInternal"));
        HashMap<String, JSONObject> commentProperties = null;
        if (restrictToInternal) {
            commentProperties = new HashMap<String, JSONObject>();
            try {
                commentProperties.put("sd.public.comment", new JSONObject("{internal:true}"));
            }
            catch (JSONException e) {
                this.log.error("Error creating Internal comment", (Throwable)e);
            }
        }
        if (!StringUtils.isBlank(rawLinkType = (String)args.get("selectedLinkType")) && rawLinkType.split(":").length != 2) {
            throw new IllegalArgumentException("Create Issue post-function is not configured with a valid link type ID.");
        }
        Long linkTypeId = null;
        boolean isInwardLink = false;
        if (!StringUtils.isBlank(rawLinkType)) {
            isInwardLink = rawLinkType.split(":")[0].equalsIgnoreCase("inward");
            try {
                linkTypeId = new Long(Long.parseLong(rawLinkType.split(":")[1]));
            }
            catch (NumberFormatException e) {
                StringBuffer sb = new StringBuffer();
                throw new IllegalArgumentException(sb.append("Create Issue post-function not configured with a valid link type ID: ").append(rawLinkType).append(" can not be parsed.").toString());
            }
        }
        MutableIssue issue = this.getIssue(transientVars);
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            return;
        }
        if (projectKey.equals("$calculated$")) {
            GroovyExpression expression = new GroovyExpression(calculatedProjectKey, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            Object res = expression.eval(this.workflowUtils, this.fieldValueService);
            if (res instanceof String) {
                try {
                    projectId = Long.parseLong((String)res);
                }
                catch (NumberFormatException e) {
                    Project p = this.projectManager.getProjectByCurrentKey((String)res);
                    if (p == null) {
                        throw new IllegalArgumentException("Invalid project key: " + res);
                    }
                    projectId = p.getId();
                }
            } else {
                try {
                    projectId = (Long)res;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid project key script", e);
                }
            }
        } else if (projectKey.equals("$sameAsCurrentIssue$")) {
            projectId = issue.getProjectObject().getId();
        } else {
            Project p = this.projectManager.getProjectByCurrentKey(projectKey);
            if (p == null) {
                throw new IllegalArgumentException("Invalid project key: " + projectKey);
            }
            projectId = p.getId();
        }
        IssueType issueType = this.issueTypeManager.getIssueType(issueTypeId);
        if (issueType == null) {
            throw new IllegalArgumentException("Create Issue post-function: could not find issue type " + issueTypeId);
        }
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters();
        issueInputParameters.setSkipScreenCheck(true);
        issueInputParameters.setApplyDefaultValuesWhenParameterNotProvided(true);
        issueInputParameters.setProjectId(projectId).setIssueTypeId(issueTypeId);
        IssueContextImpl newIssueContext = new IssueContextImpl(projectId, issueTypeId);
        WorkflowCreateIssueFunction.FieldsToSet fieldsToSetAfterCreation = new WorkflowCreateIssueFunction.FieldsToSet();
        for (Map.Entry fieldActionEntry : fieldsToSet.entrySet()) {
            FieldValueHolder fvh;
            if (this.fieldCollectionsUtils.getNonIssueInputParamFields().contains(fieldActionEntry.getKey())) {
                fieldsToSetAfterCreation.put(fieldActionEntry.getKey(), fieldActionEntry.getValue());
                continue;
            }
            if (((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getAction().equals("copy")) {
                fvh = this.fieldValueService.createFieldValueHolder((Issue)issue, (String)fieldActionEntry.getKey());
                this.fieldValueService.addValueToIssueInputParameters(issueInputParameters, (String)fieldActionEntry.getKey(), fvh, (IssueContext)newIssueContext);
                continue;
            }
            if (((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getAction().equals("set")) {
                fvh = new FieldValueHolder(((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getValue());
                this.fieldValueService.addValueToIssueInputParameters(issueInputParameters, (String)fieldActionEntry.getKey(), fvh, (IssueContext)newIssueContext);
                continue;
            }
            GroovyExpression expression = new GroovyExpression(((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getValue(), new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            String res = ((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getAction().equals("template") ? expression.evalTemplate(this.workflowUtils, this.fieldValueService) : expression.eval(this.workflowUtils, this.fieldValueService);
            FieldValueHolder fvh2 = this.fieldValueService.createFieldValueHolderFomGroovyResult(res, (String)fieldActionEntry.getKey());
            this.fieldValueService.addValueToIssueInputParameters(issueInputParameters, (String)fieldActionEntry.getKey(), fvh2, (IssueContext)newIssueContext);
        }
        ApplicationUser runAs = runAsUser == null || StringUtils.isBlank(runAsUser) ? this.getCallerUser(transientVars, args) : this.userManager.getUserByNameEvenWhenUnknown(runAsUser);
        MutableIssue parentIssue = null;
        if (issueType.isSubTask()) {
            if (StringUtils.isBlank(parentIssueKeyType) || !parentIssueKeyType.equals("currentIssue") && StringUtils.isBlank(calculatedParentIssueKey)) {
                throw new IllegalArgumentException("Create Issue post-function: issue to create is a subtask and no parent issue key was provided");
            }
            if (parentIssueKeyType.equals("currentIssue")) {
                parentIssue = issue;
            } else if (parentIssueKeyType.equals("calculated")) {
                GroovyExpression expression = new GroovyExpression(calculatedParentIssueKey, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
                expression.addIssueVariable("issue", (Issue)issue);
                calculatedParentIssueKey = (String)expression.eval(this.workflowUtils, this.fieldValueService);
                if (calculatedParentIssueKey == null || !(calculatedParentIssueKey instanceof String)) {
                    throw new IllegalArgumentException("Create Issue post-function: calculated parent issue should be a String");
                }
            }
            if (parentIssue == null && (parentIssue = this.issueManager.getIssueByCurrentKey(calculatedParentIssueKey)) == null) {
                throw new IllegalArgumentException("Create Issue post-function: specified parent issue does not exist");
            }
            createValidationResult = this.issueService.validateSubTaskCreate(runAs, parentIssue.getId(), issueInputParameters);
        } else {
            createValidationResult = this.issueService.validateCreate(runAs, issueInputParameters);
        }
        if (!createValidationResult.isValid()) {
            ErrorCollection errorCollection = createValidationResult.getErrorCollection();
            StringBuilder sb = new StringBuilder();
            if (errorCollection.hasAnyErrors()) {
                sb.append("Field validation error(s) while creating new issue:\n");
                for (String errMsg : errorCollection.getErrorMessages()) {
                    sb.append("\t" + errMsg + "\n");
                }
                for (String fieldName : errorCollection.getErrors().keySet()) {
                    sb.append("\tField " + fieldName + ": " + (String)errorCollection.getErrors().get(fieldName) + "\n");
                }
            }
            throw new IllegalArgumentException("Issue could not be created because of validation errors: " + sb.toString());
        }
        IssueService.IssueResult issueResult = this.issueService.create(runAs, createValidationResult);
        if (!issueResult.isValid()) {
            this.log.error("Issue could not be created.");
            ErrorCollection errorCollection = issueResult.getErrorCollection();
            if (errorCollection.hasAnyErrors()) {
                for (String errMsg : errorCollection.getErrorMessages()) {
                    this.log.warn("\t" + errMsg);
                }
                for (String fieldName : errorCollection.getErrors().keySet()) {
                    this.log.warn("\tField " + fieldName + ": " + (String)errorCollection.getErrors().get(fieldName));
                }
            }
            throw new IllegalArgumentException("Issue could not be created");
        }
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        for (Map.Entry fieldActionEntry : fieldsToSetAfterCreation.entrySet()) {
            FieldValueHolder fvh;
            Field f = this.fieldManager.getField((String)fieldActionEntry.getKey());
            if (((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getAction().equals("copy")) {
                fvh = this.fieldValueService.createFieldValueHolder((Issue)issue, (String)fieldActionEntry.getKey());
                this.fieldValueService.setFieldValue(issueResult.getIssue(), f, fvh, null, (IssueChangeHolder)changeHolder, false);
                continue;
            }
            if (((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getAction().equals("set")) {
                fvh = new FieldValueHolder(((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getValue());
                this.fieldValueService.setFieldValue(issueResult.getIssue(), f, fvh, null, (IssueChangeHolder)changeHolder, false);
                continue;
            }
            GroovyExpression expression = new GroovyExpression(((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getValue(), new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
            expression.addIssueVariable("issue", (Issue)issue);
            String res = ((WorkflowCreateIssueFunction.FieldAction)fieldActionEntry.getValue()).getAction().equals("template") ? expression.evalTemplate(this.workflowUtils, this.fieldValueService) : expression.eval(this.workflowUtils, this.fieldValueService);
            FieldValueHolder fvh3 = this.fieldValueService.createFieldValueHolderFomGroovyResult(res, (String)fieldActionEntry.getKey());
            this.fieldValueService.setFieldValue(issueResult.getIssue(), f, fvh3, null, (IssueChangeHolder)changeHolder, false);
        }
        if (!fieldsToSetAfterCreation.isEmpty()) {
            this.updateIssue(issueResult.getIssue(), changeHolder.getChangeItems(), runAs, false, false);
        }
        if (issueType.isSubTask()) {
            try {
                this.subTaskManager.getClass().getMethod("createSubTaskIssueLink", Issue.class, Issue.class, User.class).invoke((Object)this.subTaskManager, parentIssue, issueResult.getIssue(), runAs.getDirectoryUser());
            }
            catch (NoSuchMethodException e) {
                try {
                    this.subTaskManager.getClass().getMethod("createSubTaskIssueLink", Issue.class, Issue.class, ApplicationUser.class).invoke((Object)this.subTaskManager, parentIssue, issueResult.getIssue(), runAs);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (linkTypeId != null) {
            Long destinationIssue;
            Long sourceIssue;
            if (isInwardLink) {
                sourceIssue = issueResult.getIssue().getId();
                destinationIssue = issue.getId();
            } else {
                destinationIssue = issueResult.getIssue().getId();
                sourceIssue = issue.getId();
            }
            try {
                this.issueLinkManager.getClass().getMethod("createIssueLink", Long.class, Long.class, Long.class, Long.class, User.class).invoke((Object)this.issueLinkManager, sourceIssue, destinationIssue, linkTypeId, 0L, runAs.getDirectoryUser());
            }
            catch (NoSuchMethodException e) {
                try {
                    this.issueLinkManager.getClass().getMethod("createIssueLink", Long.class, Long.class, Long.class, Long.class, ApplicationUser.class).invoke((Object)this.issueLinkManager, sourceIssue, destinationIssue, linkTypeId, 0L, runAs);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (bCommentIssue) {
            String commentString;
            if ("expression".equals(commentType) || "template".equals(commentType)) {
                GroovyExpression expression = new GroovyExpression(commentStringOrScript, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
                expression.addIssueVariable("issue", (Issue)issue);
                expression.addVariable("newIssueKey", issueResult.getIssue().getKey());
                commentString = "template".equals(commentType) ? expression.evalTemplate(this.workflowUtils, this.fieldValueService) : (String)expression.eval(this.workflowUtils, this.fieldValueService);
            } else {
                commentString = commentStringOrScript;
            }
            if (commentString == null) {
                return;
            }
            if (StringUtils.isBlank(commentString = commentString.trim())) {
                return;
            }
            this.commentManager.create((Issue)issue, this.getCallerUser(transientVars, args), commentString, restrictToGroup, restrictToRoleID, new Date(), commentProperties, bSendCommentNotification);
        }
    }
}

