/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collection;
import java.util.Map;

public class CopyValueFromOtherFieldPostFunction
extends AbstractPreserveChangesPostFunction {
    private final FieldValueService fieldValueService;
    private final CustomFieldManager customFieldManager;

    public CopyValueFromOtherFieldPostFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, FieldValueService fieldValueService, CustomFieldManager customFieldManager, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.fieldValueService = fieldValueService;
        this.customFieldManager = customFieldManager;
    }

    @Override
    protected void executeFunction(Map<String, Object> transientVars, Map<String, String> args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        ModifiedValue mv;
        String fieldFromKey = args.get("sourceField");
        String fieldToKey = args.get("destinationField");
        String oldValue = args.get("oldValue");
        boolean bOldValue = oldValue != null && oldValue.equalsIgnoreCase("yes");
        String appendValues = args.get("appendValues");
        boolean bAppendValues = appendValues != null && appendValues.equalsIgnoreCase("yes");
        String catenateCascading = args.get("catenateCascading");
        boolean bCatenateCascading = catenateCascading != null && catenateCascading.equalsIgnoreCase("yes");
        boolean ignoreEmptyValue = "yes".equalsIgnoreCase(args.get("ignoreEmptyValue"));
        Field fieldFrom = this.workflowUtils.getFieldFromKey(fieldFromKey);
        Field fieldTo = this.workflowUtils.getFieldFromKey(fieldToKey);
        String fieldFromName = fieldFrom != null ? fieldFrom.getName() : fieldFromKey;
        String fieldToName = fieldTo != null ? fieldTo.getName() : fieldToKey;
        MutableIssue issue = this.getIssue(transientVars);
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            return;
        }
        FieldValueHolder sourceValue = null;
        sourceValue = bOldValue && issue.getModifiedFields().containsKey(fieldFromKey) ? ((mv = (ModifiedValue)issue.getModifiedFields().get(fieldFromKey)) != null ? this.fieldValueService.createFieldValueHolder(fieldFromKey, mv.getOldValue()) : this.fieldValueService.createFieldValueHolder((Issue)issue, fieldFromKey)) : this.fieldValueService.createFieldValueHolder((Issue)issue, fieldFromKey);
        if (ignoreEmptyValue && sourceValue.isEmpty()) {
            return;
        }
        if (sourceValue.size() == 2 && this.customFieldManager.isCustomField(fieldFromKey) && this.customFieldManager.getCustomFieldObject(fieldFromKey).getCustomFieldType() instanceof CascadingSelectCFType) {
            sourceValue = bCatenateCascading ? this.fieldValueService.createFieldValueHolder(fieldFromKey, (Object)sourceValue.getSingleStringValue(" - ")) : this.fieldValueService.createFieldValueHolder(fieldFromKey, sourceValue.getValue(1));
        }
        Object currentValue = null;
        if (bAppendValues || "yes".equals(args.get("copyOnlyIfNotSet"))) {
            currentValue = this.fieldValueService.getFieldValueFromIssue((Issue)issue, fieldTo, false);
        }
        if (!(!"yes".equals(args.get("copyOnlyIfNotSet")) || currentValue == null || currentValue instanceof Collection && ((Collection)currentValue).isEmpty())) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format((bAppendValues ? "Adding" : "Copying") + " value [%s] from issue %s field '%s' to '%s'", sourceValue.toString(), issue.getKey(), fieldFromName, fieldToName));
        }
        this.fieldValueService.setFieldValue(issue, fieldTo, sourceValue, bAppendValues ? currentValue : null, (IssueChangeHolder)holder, false);
        if (this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) {
            this.updateIssue(issue, holder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
        }
    }
}

