/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Collection;
import java.util.Map;

public class CopyFieldValueFromParentFunction
extends AbstractPreserveChangesPostFunction {
    private final FieldValueService fieldValueService;
    private static final String FIELD = "field";

    public CopyFieldValueFromParentFunction(WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.fieldValueService = fieldValueService;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder holder) throws WorkflowException {
        MutableIssue parentIssue;
        String fieldKey = (String)args.get(FIELD);
        boolean appendValues = "yes".equalsIgnoreCase((String)args.get("appendValues"));
        boolean ignoreEmptyValue = "yes".equalsIgnoreCase((String)args.get("ignoreEmptyValue"));
        Field field = this.workflowUtils.getFieldFromKey(fieldKey);
        if (field == null) {
            throw new IllegalArgumentException("Error while executing function : field [" + fieldKey + "] not found");
        }
        MutableIssue issue = this.getIssue(transientVars);
        Object currentValue = this.fieldValueService.getFieldValueFromIssue((Issue)issue, field, true);
        if ((currentValue == null || currentValue instanceof Collection && ((Collection)currentValue).isEmpty() || appendValues || args.get("copyOnlyIfNotSet") == null || !((String)args.get("copyOnlyIfNotSet")).equalsIgnoreCase("yes")) && (parentIssue = (MutableIssue)issue.getParentObject()) != null) {
            GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
            if (groovyExpression != null && !((Boolean)groovyExpression.addIssueVariable("parentIssue", (Issue)parentIssue).addVariable("currentValue", currentValue).eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
                return;
            }
            FieldValueHolder sourceValue = this.fieldValueService.createFieldValueHolder((Issue)parentIssue, fieldKey);
            if (!ignoreEmptyValue || !sourceValue.isEmpty()) {
                this.fieldValueService.setFieldValue(issue, field, sourceValue, appendValues ? currentValue : null, (IssueChangeHolder)holder, false);
                if (this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) {
                    this.updateIssue(issue, holder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
                }
            }
        }
    }
}

