/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.PreferencesService;
import com.innovalog.jmwe.plugins.functions.AbstractPreserveChangesPostFunction;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ServletActionContext;

public class AssignToRoleMemberFunction
extends AbstractPreserveChangesPostFunction
implements FunctionProvider {
    private final UserPropertyManager userPropertyManager;
    private final UserManager userManager;
    private final FieldValueService fieldValueService;

    protected AssignToRoleMemberFunction(UserPropertyManager userPropertyManager, ThirdPartyPluginLicenseStorageManager licenseManager, IssueUpdater issueUpdater, IssueManager issueManager, BuildUtilsInfo buildUtilsInfo, IssueIndexManager indexManager, WorkflowUtils workflowUtils, UserManager userManager, FieldValueService fieldValueService, PreferencesService preferencesService, ScriptManager scriptManager) {
        super(licenseManager, issueUpdater, issueManager, buildUtilsInfo, indexManager, workflowUtils, preferencesService, scriptManager);
        this.userPropertyManager = userPropertyManager;
        this.userManager = userManager;
        this.fieldValueService = fieldValueService;
    }

    public void executeFunction(Map transientVars, Map args, PropertySet ps, MyIssueChangeHolder issueChangeHolder) {
        String[] assigneeSelected;
        HttpServletRequest request = ServletActionContext.getRequest();
        String selectedAssigneeUserName = "-1";
        if (request != null && (assigneeSelected = request.getParameterValues("assignee")) != null && assigneeSelected.length > 0 && !(selectedAssigneeUserName = assigneeSelected[0]).equals("-1") && args.get("skipIfAssignee") != null && ((String)args.get("skipIfAssignee")).equalsIgnoreCase("yes")) {
            return;
        }
        Long projectRoleId = null;
        String rawprojectRoleId = null;
        rawprojectRoleId = (String)args.get("jira.projectrole.id");
        projectRoleId = null;
        if (StringUtils.isBlank(rawprojectRoleId)) {
            throw new IllegalArgumentException("AssignToRoleMember not configured with a valid projectroleid. (no assignment will be made)");
        }
        try {
            projectRoleId = new Long(Long.parseLong(rawprojectRoleId));
        }
        catch (NumberFormatException e) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("AssignToRoleMember not configured with a valid projectroleid, the project role id: ").append(projectRoleId).append(" can not be parsed. (no assignment will be made)").toString());
        }
        ProjectRoleManager projectRoleManager = (ProjectRoleManager)ComponentManager.getComponentInstanceOfType(ProjectRoleManager.class);
        ProjectRole projectRole = projectRoleManager.getProjectRole(projectRoleId);
        if (projectRole == null) {
            StringBuffer sb = new StringBuffer();
            throw new IllegalArgumentException(sb.append("AssignToRoleMember is configured to assign to the default user in project role that doesn't exist: id is ").append(projectRoleId).append(" (no assignment will be made)").toString());
        }
        ApplicationUser assignToUser = null;
        Issue genericIssue = (Issue)transientVars.get("issue");
        GroovyExpression groovyExpression = this.groovyCondition(transientVars, args, ps);
        if (groovyExpression != null && !((Boolean)groovyExpression.eval(this.workflowUtils, this.fieldValueService)).booleanValue()) {
            return;
        }
        Issue originalIssue = (Issue)transientVars.get("originalissueobject");
        Project project = genericIssue.getProjectObject();
        ProjectRoleActors roleActors = projectRoleManager.getProjectRoleActors(projectRole, project);
        if (!selectedAssigneeUserName.equals("-1") && args.get("forceSelectedUser") != null && ((String)args.get("forceSelectedUser")).equalsIgnoreCase("yes") && !selectedAssigneeUserName.equals(originalIssue.getAssigneeId())) {
            assignToUser = this.userManager.getUserByName(selectedAssigneeUserName);
        }
        if (roleActors != null) {
            ApplicationUser user;
            if (!selectedAssigneeUserName.equals("-1") && args.get("useSelectedUser") != null && ((String)args.get("useSelectedUser")).equalsIgnoreCase("yes") && (user = this.userManager.getUserByName(selectedAssigneeUserName)) != null && roleActors.contains(user)) {
                assignToUser = user;
            }
            if (assignToUser == null) {
                Set users = roleActors.getApplicationUsers();
                if (users != null && users.size() > 0) {
                    String propertyNameOrValue = project.getName() + "x" + projectRole.getName();
                    block2: for (ApplicationUser user2 : users) {
                        PropertySet userProperties = this.userPropertyManager.getPropertySet(user2);
                        String property = userProperties.getString("jira.meta." + propertyNameOrValue);
                        if (property != null && "default".equals(property)) {
                            assignToUser = user2;
                            break;
                        }
                        int i = 1;
                        while ((property = userProperties.getString("jira.meta.defaultAssignee" + i)) != null) {
                            if (property.equalsIgnoreCase(propertyNameOrValue)) {
                                assignToUser = user2;
                                break block2;
                            }
                            ++i;
                        }
                        if (userProperties.getString("jira.meta.defaultAssignee") == null) continue;
                        for (String s : userProperties.getString("jira.meta.defaultAssignee").split(",")) {
                            String[] t = s.split("->");
                            if (t.length != 2 || !t[0].trim().equalsIgnoreCase(project.getKey()) || !t[1].trim().equalsIgnoreCase(projectRole.getName())) continue;
                            assignToUser = user2;
                            break block2;
                        }
                    }
                    if (assignToUser == null) {
                        assignToUser = (ApplicationUser)users.iterator().next();
                        StringBuffer sb = new StringBuffer();
                        this.log.info(sb.append("AssignToRoleMember was not able to find a user with the property named ").append(propertyNameOrValue).append(" and value set to \"default\". First user from the role will be used.").toString());
                    }
                } else {
                    StringBuffer sb = new StringBuffer();
                    this.log.info(sb.append("There are no users assigned in the project role ").append(projectRole.getName()).append(" (no assignment will be made)").toString());
                    return;
                }
            }
        }
        if (assignToUser == null) {
            StringBuffer sb = new StringBuffer();
            this.log.info(sb.append("There is no default user assigned in the project role ").append(projectRole.getName()).append(" (no assignment will be made)").toString());
            return;
        }
        this.log.info("AssignToRoleMember assigning to: " + assignToUser.getName());
        MutableIssue issue = (MutableIssue)transientVars.get("issue");
        if (!assignToUser.getName().equals(selectedAssigneeUserName)) {
            issue.setAssigneeId(assignToUser.getKey());
            if (this.shouldUpdateCurrentIssue((Issue)issue, transientVars, args)) {
                this.updateIssue(issue, issueChangeHolder.getChangeItems(), this.getCallerUser(transientVars, args), false, true);
            }
        }
    }
}

