/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.conditions;

import com.atlassian.jira.plugin.workflow.WorkflowPluginConditionFactory;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import java.util.HashMap;
import java.util.Map;
import webwork.action.ActionContext;
import webwork.action.factory.ParameterMap;

public class WorkflowPreviousStatusCondition
extends AbstractLicensedWorkflowPluginFactory
implements WorkflowPluginConditionFactory {
    private final WorkflowManager wm;

    protected WorkflowPreviousStatusCondition(ThirdPartyPluginLicenseStorageManager licenseManager, WorkflowManager wm) {
        super(licenseManager);
        this.wm = wm;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        ActionContext ctx = ActionContext.getContext();
        ParameterMap pm = (ParameterMap)ctx.get((Object)"webwork.action.ActionContext.parameters");
        String workflowName = ((String[])pm.get((Object)"workflowName"))[0];
        JiraWorkflow workflow = this.wm.getWorkflow(workflowName);
        velocityParams.put("statusList", workflow.getLinkedStatusObjects());
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        ConditionDescriptor conditionDescriptor = (ConditionDescriptor)descriptor;
        String statusString = (String)conditionDescriptor.getArgs().get("jira.previousstatus");
        velocityParams.put("selectedStatus", statusString);
        String mostRecentStatusOnly = (String)conditionDescriptor.getArgs().get("jira.mostRecentStatusOnly");
        velocityParams.put("mostRecentOnly", mostRecentStatusOnly);
        String includeCurrent = (String)conditionDescriptor.getArgs().get("jira.includeCurrent");
        velocityParams.put("includeCurrent", includeCurrent);
        String ignoreLoopTransitions = (String)conditionDescriptor.getArgs().get("jira.ignoreLoopTransitions");
        velocityParams.put("ignoreLoopTransitions", ignoreLoopTransitions);
        String not = (String)conditionDescriptor.getArgs().get("jira.not");
        velocityParams.put("not", not);
    }

    public Map getDescriptorParams(Map formParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String selectedStatus = this.extractSingleParam(formParams, "status");
            params.put("jira.previousstatus", selectedStatus);
        }
        catch (IllegalArgumentException selectedStatus) {
            // empty catch block
        }
        try {
            String mostRecentStatusOnlyString = this.extractSingleParam(formParams, "mostRecentOnly");
            params.put("jira.mostRecentStatusOnly", mostRecentStatusOnlyString);
        }
        catch (IllegalArgumentException e) {
            params.put("jira.mostRecentStatusOnly", "no");
        }
        try {
            String includeCurrentString = this.extractSingleParam(formParams, "includeCurrent");
            params.put("jira.includeCurrent", includeCurrentString);
        }
        catch (IllegalArgumentException e) {
            params.put("jira.includeCurrent", "no");
        }
        try {
            String ignoreLoopTransitionsString = this.extractSingleParam(formParams, "ignoreLoopTransitions");
            params.put("jira.ignoreLoopTransitions", ignoreLoopTransitionsString);
        }
        catch (IllegalArgumentException e) {
            params.put("jira.ignoreLoopTransitions", "no");
        }
        try {
            String notString = this.extractSingleParam(formParams, "not");
            params.put("jira.not", notString);
        }
        catch (IllegalArgumentException e) {
            params.put("jira.not", "no");
        }
        return params;
    }
}

