/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.conditions;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.conditions.LicensedCondition;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class SeparationOfDutiesCondition
extends LicensedCondition {
    public SeparationOfDutiesCondition(ThirdPartyPluginLicenseStorageManager licenseManager) {
        super(licenseManager);
    }

    @Override
    public boolean doPassesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        Issue genericIssue = (Issue)transientVars.get("issue");
        String fromStatus = (String)args.get("fromStatus");
        String toStatus = (String)args.get("toStatus");
        ApplicationUser caller = this.getCallerUser(transientVars, args);
        ChangeHistoryManager changeHistoryManager = (ChangeHistoryManager)ComponentManager.getComponentInstanceOfType(ChangeHistoryManager.class);
        List changeHistory = changeHistoryManager.getChangeHistories(genericIssue);
        this.log.debug("SeparationOfDutiesCondition: Looking for history entries of issue " + genericIssue.getKey() + " made by username " + caller.getName());
        for (int i = changeHistory.size() - 1; i >= 0; --i) {
            ChangeHistory changeHistoryItem = (ChangeHistory)changeHistory.get(i);
            if (changeHistoryItem.getAuthorObject() == null || !changeHistoryItem.getAuthorObject().equals((Object)caller)) continue;
            this.log.debug("SeparationOfDutiesCondition: Found history entry for username " + caller.getName() + " made on " + changeHistoryItem.getTimePerformed().toString());
            List changeItemBeans = changeHistoryItem.getChangeItems();
            for (GenericValue change : changeItemBeans) {
                String changedField = change.getString("field");
                if (!changedField.equalsIgnoreCase("status")) continue;
                String oldStatus = change.getString("oldstring");
                String newStatus = change.getString("newstring");
                this.log.debug("SeparationOfDutiesCondition: Found entry for status field from '" + oldStatus + "' to '" + newStatus + "'");
                if (!fromStatus.equals("") && !oldStatus.equalsIgnoreCase(fromStatus) || !newStatus.equalsIgnoreCase(toStatus)) continue;
                return false;
            }
        }
        this.log.debug("SeparationOfDutiesCondition: Found no matching history entry");
        return true;
    }
}

