/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.conditions;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.conditions.LicensedCondition;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviousStatusCondition
extends LicensedCondition {
    private Logger log = LoggerFactory.getLogger(PreviousStatusCondition.class);

    public PreviousStatusCondition(ThirdPartyPluginLicenseStorageManager licenseManager) {
        super(licenseManager);
    }

    @Override
    public boolean doPassesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        Issue genericIssue = (Issue)transientVars.get("issue");
        String statusToLookFor = (String)args.get("jira.previousstatus");
        boolean mostRecentStatusOnly = "yes".equals(args.get("jira.mostRecentStatusOnly"));
        boolean includeCurrent = "yes".equals(args.get("jira.includeCurrent"));
        boolean ignoreLoopTransitions = !"no".equals(args.get("jira.ignoreLoopTransitions"));
        boolean not = "yes".equals(args.get("jira.not"));
        this.log.debug("Issue " + genericIssue.getKey() + ": looking for " + statusToLookFor + " previous status");
        if (includeCurrent && !not && genericIssue.getStatusObject().getName().equalsIgnoreCase(statusToLookFor)) {
            return true;
        }
        ChangeHistoryManager changeHistoryManager = (ChangeHistoryManager)ComponentManager.getComponentInstanceOfType(ChangeHistoryManager.class);
        List changeHistory = changeHistoryManager.getChangeHistories(genericIssue);
        block0: for (int i = changeHistory.size() - 1; i >= 0; --i) {
            ChangeHistory changeHistoryItem = (ChangeHistory)changeHistory.get(i);
            List changeItemBeans = changeHistoryItem.getChangeItems();
            for (GenericValue change : changeItemBeans) {
                String changedField = change.getString("field");
                if (!changedField.equalsIgnoreCase("status")) continue;
                String oldStatus = change.getString("oldstring");
                String newStatus = change.getString("newstring");
                if (ignoreLoopTransitions && oldStatus.equals(newStatus)) continue block0;
                if (oldStatus.compareToIgnoreCase(statusToLookFor) == 0) {
                    return !not;
                }
                if (!mostRecentStatusOnly) continue;
                return not;
            }
        }
        return not;
    }
}

