/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.conditions;

import com.atlassian.jira.issue.Issue;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.groovy.ScriptManager;
import com.innovalog.jmwe.plugins.WorkflowContext;
import com.innovalog.jmwe.plugins.conditions.LicensedCondition;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.innovalog.workflow.utils.FieldValueService;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;
import java.util.Map;

public class GroovyCondition
extends LicensedCondition {
    private final WorkflowUtils workflowUtils;
    private final FieldValueService fieldValueService;
    private final ScriptManager scriptManager;

    public GroovyCondition(ThirdPartyPluginLicenseStorageManager licenseManager, WorkflowUtils workflowUtils, FieldValueService fieldValueService, ScriptManager scriptManager) {
        super(licenseManager);
        this.workflowUtils = workflowUtils;
        this.fieldValueService = fieldValueService;
        this.scriptManager = scriptManager;
    }

    @Override
    public boolean doPassesCondition(Map transientVars, Map args, PropertySet ps) throws WorkflowException {
        String groovyExpression = Utils.decodeTemplate((String)args.get("groovyExpression"));
        if (groovyExpression == null || groovyExpression.isEmpty()) {
            return true;
        }
        GroovyExpression expression = new GroovyExpression(groovyExpression, new WorkflowContext(transientVars, args, ps).toString(), this.scriptManager);
        expression.addIssueVariable("issue", (Issue)transientVars.get("issue"));
        return (Boolean)expression.eval(this.workflowUtils, this.fieldValueService);
    }
}

