/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.license.storage.lib.PluginLicenseStoragePluginUnresolvedException;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import java.util.Date;
import java.util.Map;

public abstract class AbstractLicensedWorkflowPluginFactory
extends AbstractWorkflowPluginFactory {
    static final String IS_ON_DEMAND = "isOnDemand";
    protected final ThirdPartyPluginLicenseStorageManager licenseManager;

    protected AbstractLicensedWorkflowPluginFactory(ThirdPartyPluginLicenseStorageManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public Map<String, Object> getVelocityParams(String resourceName, AbstractDescriptor descriptor) {
        Map velocityParams = super.getVelocityParams(resourceName, descriptor);
        if (this.licenseManager.isOnDemand()) {
            velocityParams.put(IS_ON_DEMAND, "true");
        }
        if (!this.licenseManager.isOnDemand() || new Date().after(new Date(117, 2, 1))) {
            try {
                if (this.licenseManager.getLicense().isDefined()) {
                    PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                    if (pluginLicense.getError().isDefined()) {
                        velocityParams.put("licenseError", "Your JIRA Misc Workflow Extensions license has an error: " + ((LicenseError)pluginLicense.getError().get()).name());
                    }
                } else {
                    velocityParams.put("licenseError", "You don't have a JIRA Misc Workflow Extensions license.");
                }
            }
            catch (PluginLicenseStoragePluginUnresolvedException e) {
                velocityParams.put("licenseError", "Could not find License Storage plugin.");
            }
        }
        return velocityParams;
    }

    public static String getFieldDesc(String fieldName) {
        CustomFieldManager cfm = (CustomFieldManager)ComponentManager.getComponent(CustomFieldManager.class);
        CustomField customField = cfm.getCustomFieldObjectByName(fieldName);
        if (customField == null) {
            return "";
        }
        return customField.getDescription();
    }
}

