/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.groovy;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.groovy.GroovyExpression;
import com.innovalog.workflow.utils.FieldValueHolder;
import com.innovalog.workflow.utils.FieldValueService;
import com.innovalog.workflow.utils.MyIssueChangeHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class IssueGroovyMethods {
    private static WorkflowUtils getWorkflowUtils() {
        return GroovyExpression.getWorkflowUtils();
    }

    private static FieldValueService getFieldValueService() {
        return GroovyExpression.getFieldValueService();
    }

    private static MyIssueChangeHolder getIssueChangeHolder(MutableIssue issue) {
        return GroovyExpression.getIssueChangeHolder(issue);
    }

    private static IssueLinkManager getIssueLinkManager() {
        return (IssueLinkManager)ComponentAccessor.getComponent(IssueLinkManager.class);
    }

    private static IssueSecurityLevelManager getIssueSecurityLevelManager() {
        return ComponentAccessor.getIssueSecurityLevelManager();
    }

    private static IssueLinkTypeManager getIssueLinkTypeManager() {
        return (IssueLinkTypeManager)ComponentAccessor.getComponent(IssueLinkTypeManager.class);
    }

    public static Object get(Issue issue, String fieldName) {
        WorkflowUtils workflowUtils = IssueGroovyMethods.getWorkflowUtils();
        FieldValueService fieldValueService = IssueGroovyMethods.getFieldValueService();
        Field field = workflowUtils.getFieldFromKey(fieldName);
        return fieldValueService.getFieldValueFromIssue(issue, field, true);
    }

    public static String getAsString(Issue issue, String fieldName) {
        WorkflowUtils workflowUtils = IssueGroovyMethods.getWorkflowUtils();
        FieldValueService fieldValueService = IssueGroovyMethods.getFieldValueService();
        Field field = workflowUtils.getFieldFromKey(fieldName);
        FieldValueHolder value = fieldValueService.createFieldValueHolder(issue, field.getId());
        return value.getSingleStringValue(",");
    }

    public static Object getRawValue(Issue issue, String fieldName) {
        WorkflowUtils workflowUtils = IssueGroovyMethods.getWorkflowUtils();
        FieldValueService fieldValueService = IssueGroovyMethods.getFieldValueService();
        Field field = workflowUtils.getFieldFromKey(fieldName);
        return fieldValueService.getFieldValueFromIssue(issue, field, false);
    }

    public static Issue getIssueObject(Issue issue) {
        return issue;
    }

    public static List<IssueLink> getInwardIssueLinks(Issue issue) {
        IssueLinkManager issueLinkManager = IssueGroovyMethods.getIssueLinkManager();
        return issueLinkManager.getInwardLinks(issue.getId());
    }

    public static List<IssueLink> getOutwardIssueLinks(Issue issue) {
        IssueLinkManager issueLinkManager = IssueGroovyMethods.getIssueLinkManager();
        return issueLinkManager.getOutwardLinks(issue.getId());
    }

    public static List<Issue> getLinkedIssues(Issue issue, String linkType) {
        IssueLinkManager issueLinkManager = IssueGroovyMethods.getIssueLinkManager();
        IssueLinkTypeManager issueLinkTypeManager = IssueGroovyMethods.getIssueLinkTypeManager();
        Collection issueLinkTypes = issueLinkTypeManager.getIssueLinkTypes(false);
        for (IssueLinkType issueLinkType : issueLinkTypes) {
            if (issueLinkType.getInward().equals(linkType)) {
                List inwardLinks = issueLinkManager.getInwardLinks(issue.getId());
                ArrayList<Issue> issues = new ArrayList<Issue>();
                for (IssueLink issueLink : inwardLinks) {
                    if (!Objects.equals(issueLink.getLinkTypeId(), issueLinkType.getId())) continue;
                    issues.add(issueLink.getSourceObject());
                }
                return issues;
            }
            if (!issueLinkType.getOutward().equals(linkType)) continue;
            List outwardLinks = issueLinkManager.getOutwardLinks(issue.getId());
            ArrayList<Issue> issues = new ArrayList<Issue>(outwardLinks.size());
            for (IssueLink issueLink : outwardLinks) {
                if (!Objects.equals(issueLink.getLinkTypeId(), issueLinkType.getId())) continue;
                issues.add(issueLink.getDestinationObject());
            }
            return issues;
        }
        return Collections.EMPTY_LIST;
    }

    public static Issue getEpic(Issue issue) {
        List<Issue> linkedIssues = IssueGroovyMethods.getLinkedIssues(issue, "has Epic");
        if (linkedIssues.size() > 0) {
            return (Issue)linkedIssues.iterator().next();
        }
        return null;
    }

    public static List<Issue> getStories(Issue issue) {
        return IssueGroovyMethods.getLinkedIssues(issue, "is Epic of");
    }

    public static <T> Collection<T> getAvailableOptions(Issue issue, String fieldName) {
        return IssueGroovyMethods.getWorkflowUtils().getAvailableOptions(issue, fieldName);
    }

    public static void setFieldValue(MutableIssue issue, String fieldName, Object value) {
        FieldValueService fieldValueService = IssueGroovyMethods.getFieldValueService();
        Field field = IssueGroovyMethods.getWorkflowUtils().getFieldFromKey(fieldName);
        if (field == null) {
            throw new IllegalArgumentException("setFieldValue: could not find field '" + fieldName + "'");
        }
        MyIssueChangeHolder issueChangeHolder = IssueGroovyMethods.getIssueChangeHolder(issue);
        if (issueChangeHolder == null) {
            throw new IllegalStateException("Calling setFieldValue() from this context is not authorized.");
        }
        FieldValueHolder fvh = fieldValueService.createFieldValueHolderFomGroovyResult(value, field.getId());
        fieldValueService.setFieldValue(issue, field, fvh, null, (IssueChangeHolder)issueChangeHolder, false);
        issueChangeHolder.setChanged(true);
    }
}

