/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.util;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ComponentConverter;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.MultipleSettableCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.ProjectCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.issue.worklog.WorkRatio;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.google.common.base.Throwables;
import com.googlecode.jsu.helpers.checkers.ConverterString;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowUtils {
    public static final String SPLITTER = "@@";
    private final WorkflowActionsBean workflowActionsBean = new WorkflowActionsBean();
    private final Logger log = LoggerFactory.getLogger(WorkflowUtils.class);
    private final FieldManager fieldManager;
    private final IssueManager issueManager;
    private final ProjectComponentManager projectComponentManager;
    private final VersionManager versionManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final ApplicationProperties applicationProperties;
    private final FieldCollectionsUtils fieldCollectionsUtils;
    private final IssueLinkManager issueLinkManager;
    private final UserManager userManager;
    private final CrowdService crowdService;
    private final OptionsManager optionsManager;
    private final ProjectManager projectManager;
    private final LabelManager labelManager;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private final ConstantsManager constantsManager;
    private final BuildUtilsInfo buildUtilsInfo;
    private final WatcherManager watcherManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CommentManager commentManager;
    private final ComponentConverter componentConverter;
    private final CustomFieldManager customFieldManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private static final ConverterString CONVERTER_STRING = new ConverterString();

    public WorkflowUtils(FieldManager fieldManager, IssueManager issueManager, ProjectComponentManager projectComponentManager, VersionManager versionManager, IssueSecurityLevelManager issueSecurityLevelManager, ApplicationProperties applicationProperties, FieldCollectionsUtils fieldCollectionsUtils, IssueLinkManager issueLinkManager, UserManager userManager, CrowdService crowdService, OptionsManager optionsManager, ProjectManager projectManager, LabelManager labelManager, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory, ConstantsManager constantsManager, BuildUtilsInfo buildUtilsInfo, WatcherManager watcherManager, JiraAuthenticationContext authenticationContext, CommentManager commentManager, CustomFieldManager customFieldManager, IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.fieldManager = fieldManager;
        this.issueManager = issueManager;
        this.projectComponentManager = projectComponentManager;
        this.versionManager = versionManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.applicationProperties = applicationProperties;
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.issueLinkManager = issueLinkManager;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.optionsManager = optionsManager;
        this.projectManager = projectManager;
        this.labelManager = labelManager;
        this.aggregateTimeTrackingCalculatorFactory = aggregateTimeTrackingCalculatorFactory;
        this.constantsManager = constantsManager;
        this.buildUtilsInfo = buildUtilsInfo;
        this.watcherManager = watcherManager;
        this.authenticationContext = authenticationContext;
        this.commentManager = commentManager;
        this.componentConverter = new ComponentConverter();
        this.customFieldManager = customFieldManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
    }

    public String getFieldNameFromKey(String key) {
        return this.getFieldFromKey(key).getName();
    }

    public Field getFieldFromKey(String key) {
        Collection fields;
        Object field = this.fieldManager.isCustomField(key) ? this.fieldManager.getCustomField(key) : this.fieldManager.getField(key);
        if (field == null && (fields = this.customFieldManager.getCustomFieldObjectsByName(key)) != null) {
            if (fields.size() > 1) {
                throw new IllegalArgumentException("More than one custom fields were found named '" + key + "'. Use the 'customfield_xxxxx' form instead.");
            }
            if (fields.size() == 0) {
                List<Field> allFields = this.fieldCollectionsUtils.getAllFields();
                for (Field f : allFields) {
                    if (!f.getName().equals(key)) continue;
                    return f;
                }
            } else {
                field = (Field)fields.iterator().next();
            }
        }
        if (field == null) {
            throw new IllegalArgumentException("Unable to find field '" + key + "'");
        }
        return field;
    }

    public Field getFieldFromDescriptor(AbstractDescriptor descriptor, String name) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        Map args = functionDescriptor.getArgs();
        String fieldKey = (String)args.get(name);
        try {
            return this.getFieldFromKey(fieldKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getFieldValueFromIssue(Issue issue, Field field, boolean catenateCascade) {
        Object retVal = null;
        try {
            if (this.fieldManager.isCustomField(field)) {
                CustomField customField = (CustomField)field;
                ArrayList value = issue.getCustomFieldValue(customField);
                if (customField.getCustomFieldType() instanceof CascadingSelectCFType && value != null) {
                    retVal = new CascadingSelectValue((HashMap)((Object)value), catenateCascade);
                    if (catenateCascade && retVal != null) {
                        retVal = retVal.toString();
                    }
                } else {
                    retVal = value instanceof Option ? ((Object)value).toString() : value;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("Got field value [object=%s;class=%s]", retVal, retVal != null ? retVal.getClass() : ""));
                }
            } else {
                String fieldId = field.getId();
                Collection retCollection = null;
                if (fieldId.equals("attachment")) {
                    retCollection = issue.getAttachments();
                    if (retCollection != null && !retCollection.isEmpty()) {
                        retVal = retCollection;
                    }
                } else if (fieldId.equals("versions")) {
                    retCollection = issue.getAffectedVersions();
                    if (retCollection != null && !retCollection.isEmpty()) {
                        retVal = retCollection;
                    }
                } else if (fieldId.equals("comment")) {
                    retVal = this.commentManager.getComments(issue);
                } else if (fieldId.equals("components")) {
                    retCollection = issue.getComponentObjects();
                    if (retCollection != null && !retCollection.isEmpty()) {
                        retVal = retCollection;
                    }
                } else if (fieldId.equals("fixVersions")) {
                    retCollection = issue.getFixVersions();
                    if (retCollection != null && !retCollection.isEmpty()) {
                        retVal = retCollection;
                    }
                } else if (!fieldId.equals("thumbnail")) {
                    if (fieldId.equals("issuetype")) {
                        retVal = issue.getIssueTypeObject();
                    } else if (!fieldId.equals("timetracking")) {
                        if (fieldId.equals("issuelinks")) {
                            retVal = new ArrayList(this.issueLinkManager.getOutwardLinks(issue.getId()));
                            ((Collection)retVal).addAll(this.issueLinkManager.getInwardLinks(issue.getId()));
                        } else if (fieldId.equals("workratio")) {
                            retVal = String.valueOf(WorkRatio.getWorkRatio((Issue)issue));
                        } else if (fieldId.equals("issuekey")) {
                            retVal = issue.getKey();
                        } else if (fieldId.equals("subtasks")) {
                            retCollection = issue.getSubTaskObjects();
                            if (retCollection != null && !retCollection.isEmpty()) {
                                retVal = retCollection;
                            }
                        } else if (fieldId.equals("priority")) {
                            retVal = issue.getPriorityObject();
                        } else if (fieldId.equals("resolution")) {
                            retVal = issue.getResolutionObject();
                        } else if (fieldId.equals("status")) {
                            retVal = issue.getStatusObject();
                        } else if (fieldId.equals("project")) {
                            retVal = issue.getProjectObject();
                        } else if (fieldId.equals("security")) {
                            retVal = issue.getSecurityLevelId();
                        } else if (fieldId.equals("timeestimate")) {
                            retVal = issue.getEstimate();
                        } else if (fieldId.equals("timeoriginalestimate")) {
                            retVal = issue.getOriginalEstimate();
                        } else if (fieldId.equals("timespent")) {
                            retVal = issue.getTimeSpent();
                        } else if (fieldId.equals("aggregatetimespent")) {
                            retVal = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue).getTimeSpent();
                        } else if (fieldId.equals("aggregatetimeestimate")) {
                            retVal = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue).getRemainingEstimate();
                        } else if (fieldId.equals("aggregatetimeoriginalestimate")) {
                            retVal = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue).getOriginalEstimate();
                        } else if (fieldId.equals("assignee")) {
                            retVal = issue.getClass().getMethod("getAssigneeUser", new Class[0]).invoke((Object)issue, new Object[0]);
                        } else if (fieldId.equals("creator")) {
                            retVal = issue.getClass().getMethod("getCreator", new Class[0]).invoke((Object)issue, new Object[0]);
                        } else if (fieldId.equals("reporter")) {
                            retVal = issue.getClass().getMethod("getReporterUser", new Class[0]).invoke((Object)issue, new Object[0]);
                        } else if (fieldId.equals("description")) {
                            retVal = issue.getDescription();
                        } else if (fieldId.equals("environment")) {
                            retVal = issue.getEnvironment();
                        } else if (fieldId.equals("summary")) {
                            retVal = issue.getSummary();
                        } else if (fieldId.equals("duedate")) {
                            retVal = issue.getDueDate();
                        } else if (fieldId.equals("updated")) {
                            retVal = issue.getUpdated();
                        } else if (fieldId.equals("created")) {
                            retVal = issue.getCreated();
                        } else if (fieldId.equals("resolutiondate")) {
                            retVal = issue.getResolutionDate();
                        } else if (fieldId.equals("labels")) {
                            retVal = issue.getLabels();
                        } else if (fieldId.equals("watches")) {
                            retVal = this.watcherManager.getWatchers(issue, this.authenticationContext.getLocale());
                        } else {
                            this.log.warn("Issue field \"" + fieldId + "\" is not supported.");
                            GenericValue gvIssue = issue.getGenericValue();
                            if (gvIssue != null) {
                                retVal = gvIssue.get(fieldId);
                            }
                        }
                    }
                }
            }
        }
        catch (NullPointerException e) {
            retVal = null;
            this.log.error("Unable to get field \"" + field.getId() + "\" value", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            retVal = null;
            this.log.error("Unable to get field \"" + field.getId() + "\" value", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            retVal = null;
            this.log.error("Unable to get field \"" + field.getId() + "\" value", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            retVal = null;
            this.log.error("Unable to get field \"" + field.getId() + "\" value", (Throwable)e);
        }
        return retVal;
    }

    public void setFieldValue(MutableIssue issue, Field field, Object value, IssueChangeHolder changeHolder) {
        this.setFieldValue(issue, field, value, changeHolder, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFieldValue(MutableIssue issue, Field field, Object value, IssueChangeHolder changeHolder, boolean updateValue) {
        if (this.fieldManager.isCustomField(field)) {
            void var10_58;
            CustomFieldParamsImpl fieldParams;
            void var10_39;
            CustomField customField = (CustomField)field;
            Object oldValue = issue.getCustomFieldValue(customField);
            CustomFieldType cfType = customField.getCustomFieldType();
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Set custom field value [field=%s,type=%s,oldValue=%s,newValueClass=%s,newValue=%s]", customField, cfType, oldValue, value != null ? value.getClass().getName() : "null", value));
            }
            FieldLayoutItem fieldLayoutItem = this.fieldCollectionsUtils.getFieldLayoutItem((Issue)issue, field);
            Collection<Version> collection = value;
            if (value instanceof IssueConstant) {
                String string = ((IssueConstant)value).getName();
            } else if (value instanceof GenericValue) {
                GenericValue gv = (GenericValue)value;
                if ("SchemeIssueSecurityLevels".equals(gv.getEntityName())) {
                    String string = gv.getString("name");
                }
            } else if (value instanceof Option && !(cfType instanceof MultipleSettableCustomFieldType)) {
                String string = ((Option)collection).getValue();
            } else if (value instanceof Timestamp && !this.fieldCollectionsUtils.getAllDateFields().contains(field)) {
                String format = this.applicationProperties.getDefaultBackedString("jira.date.time.picker.java.format");
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                String string = dateFormat.format(value);
            } else if (value instanceof CascadingSelectValue && !(cfType instanceof CascadingSelectCFType)) {
                String string = value.toString();
            }
            if (cfType instanceof VersionCFType) {
                Collection<Version> collection2 = this.convertValueToVersions((Issue)issue, var10_39);
            } else if (cfType instanceof ProjectCFType) {
                Project project = this.convertValueToProject(var10_39);
                if (project != null && this.buildUtilsInfo.getVersionNumbers()[0] < 7) {
                    GenericValue genericValue = project.getGenericValue();
                } else {
                    Project project2 = project;
                }
            } else if (var10_39 instanceof String) {
                if (cfType instanceof MultipleSettableCustomFieldType) {
                    Option option = this.convertStringToOption((Issue)issue, customField, (String)var10_39);
                    if (cfType instanceof MultiSelectCFType) {
                        ArrayList<Option> arrayList = this.asArrayList(option);
                    } else if (cfType instanceof CascadingSelectCFType) {
                        Map map = this.convertOptionToCustomFieldParamsImpl(customField, option);
                    } else {
                        Option option2 = option;
                    }
                } else if (cfType instanceof LabelsCFType && ((String)var10_39).contains(" ")) {
                    String[] labels = ((String)var10_39).split(" +");
                    CustomFieldParamsImpl fieldParams2 = new CustomFieldParamsImpl(customField, (Object)labels);
                    Object object = cfType.getValueFromCustomFieldParams((CustomFieldParams)fieldParams2);
                } else {
                    fieldParams = new CustomFieldParamsImpl(customField, (Object)var10_39);
                    Object object = cfType.getValueFromCustomFieldParams((CustomFieldParams)fieldParams);
                }
            } else if (var10_39 instanceof Collection) {
                if (customField.getCustomFieldType() instanceof MultiUserCFType) {
                    Object object = this.convertValueToAppUsers(var10_39);
                } else if (!(customField.getCustomFieldType() instanceof AbstractMultiCFType) && !(customField.getCustomFieldType() instanceof MultipleCustomFieldType)) {
                    if (customField.getCustomFieldType() instanceof LabelsCFType) {
                        if (!(var10_39 instanceof Set)) {
                            HashSet hashSet = new HashSet((Collection)var10_39);
                        }
                    } else if (cfType.getClass().getPackage().getName().equals("com.valiantys.jira.plugins.sql.customfield")) {
                        fieldParams = new CustomFieldParamsImpl(customField, (Object)var10_39);
                        Object object = cfType.getValueFromCustomFieldParams((CustomFieldParams)fieldParams);
                    } else {
                        fieldParams = new CustomFieldParamsImpl(customField, (Object)StringUtils.join((Collection)((Collection)var10_39), (String)","));
                        Object object = cfType.getValueFromCustomFieldParams((CustomFieldParams)fieldParams);
                    }
                }
            } else if (var10_39 instanceof Option && !(cfType instanceof MultipleSettableCustomFieldType)) {
                String string = ((Option)var10_39).getValue();
            } else if (cfType instanceof UserCFType) {
                Object object = this.convertValueToAppUser(var10_39);
            } else if (cfType instanceof AbstractMultiCFType) {
                if (cfType instanceof MultiUserCFType) {
                    Object object = this.convertValueToAppUsers(var10_39);
                }
            } else if (UserCompatibilityHelper.isUserObject(var10_39)) {
                String string = UserCompatibilityHelper.convertUserObject(var10_39).getKey();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Got new value [class=" + (var10_58 != null ? var10_58.getClass().getName() : "null") + ",value=" + var10_58 + "]");
            }
            issue.setCustomFieldValue(customField, (Object)var10_58);
            if (updateValue) {
                customField.updateValue(fieldLayoutItem, (Issue)issue, new ModifiedValue(oldValue, (Object)var10_58), changeHolder);
            }
            if (!this.log.isDebugEnabled()) return;
            this.log.debug("Issue [" + issue + "] got modfied fields - [" + issue.getModifiedFields() + "]");
            return;
        } else {
            String fieldId = field.getId();
            if (fieldId.equals("attachment")) {
                throw new UnsupportedOperationException("Not implemented");
            }
            if (fieldId.equals("versions")) {
                Collection<Version> versions = this.convertValueToVersions((Issue)issue, value);
                issue.setAffectedVersions(versions);
                return;
            } else {
                if (fieldId.equals("comment")) {
                    throw new UnsupportedOperationException("Not implemented");
                }
                if (fieldId.equals("components")) {
                    Collection<ProjectComponent> components = this.convertValueToComponents((Issue)issue, value);
                    this.setIssueComponents(issue, components);
                    return;
                } else if (fieldId.equals("fixVersions")) {
                    Collection<Version> versions = this.convertValueToVersions((Issue)issue, value);
                    issue.setFixVersions(versions);
                    return;
                } else {
                    if (fieldId.equals("thumbnail")) {
                        throw new UnsupportedOperationException("Not implemented");
                    }
                    if (fieldId.equals("issuetype")) {
                        if (value instanceof String) {
                            issue.setIssueTypeId((String)((Object)value));
                            return;
                        } else if (value instanceof GenericValue) {
                            issue.setIssueTypeId(((GenericValue)value).getString("id"));
                            return;
                        } else {
                            if (!(value instanceof IssueType)) throw new IllegalArgumentException("Invalid Issue Type: " + value);
                            issue.setIssueTypeObject((IssueType)value);
                        }
                        return;
                    } else {
                        if (fieldId.equals("timetracking")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("issuelinks")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("workratio")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("issuekey")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("subtasks")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("priority")) {
                            if (value == null) {
                                issue.setPriority(null);
                                return;
                            } else if (value instanceof GenericValue) {
                                issue.setStatusId(((GenericValue)value).getString("id"));
                                return;
                            } else if (value instanceof Priority) {
                                issue.setPriorityId(((Priority)value).getId());
                                return;
                            } else {
                                Priority priority = this.constantsManager.getPriorityObject(value.toString());
                                if (priority == null) throw new IllegalArgumentException("Unable to find priority with name \"" + value + "\"");
                                issue.setPriorityId(priority.getId());
                            }
                            return;
                        } else if (fieldId.equals("resolution")) {
                            if (value == null) {
                                issue.setResolution(null);
                                return;
                            } else if (value instanceof GenericValue) {
                                issue.setResolutionId(((GenericValue)value).getString("id"));
                                return;
                            } else if (value instanceof Resolution) {
                                issue.setResolutionId(((Resolution)value).getId());
                                return;
                            } else {
                                Collection resolutions = this.constantsManager.getResolutionObjects();
                                Resolution resolution = null;
                                String s = value.toString().trim();
                                for (Resolution r : resolutions) {
                                    if (!r.getName().equalsIgnoreCase(s)) continue;
                                    resolution = r;
                                    break;
                                }
                                if (resolution == null) throw new IllegalArgumentException("Unable to find resolution with name \"" + value + "\"");
                                issue.setResolutionId(resolution.getId());
                            }
                            return;
                        } else if (fieldId.equals("status")) {
                            if (value == null) {
                                issue.setStatus(null);
                                return;
                            } else if (value instanceof GenericValue) {
                                issue.setStatusId(((GenericValue)value).getString("id"));
                                return;
                            } else if (value instanceof Status) {
                                issue.setStatusId(((Status)value).getId());
                                return;
                            } else {
                                Status status = this.constantsManager.getStatusByName(value.toString());
                                if (status == null) throw new IllegalArgumentException("Unable to find status with name \"" + value + "\"");
                                issue.setStatusId(status.getId());
                            }
                            return;
                        } else if (fieldId.equals("security")) {
                            if (value == null) {
                                issue.setSecurityLevel(null);
                                return;
                            } else if (value instanceof GenericValue) {
                                issue.setSecurityLevel((GenericValue)value);
                                return;
                            } else if (value instanceof Long) {
                                issue.setSecurityLevelId((Long)((Object)value));
                                return;
                            } else {
                                try {
                                    Long l = Long.decode(value.toString());
                                    issue.setSecurityLevelId(l);
                                    return;
                                }
                                catch (NumberFormatException ignore) {
                                    void var10_62;
                                    Collection levels = this.issueSecurityLevelManager.getIssueSecurityLevelsByName(value.toString());
                                    if (levels == null || levels.size() == 0) {
                                        throw new IllegalArgumentException("Unable to find security level \"" + value + "\"");
                                    }
                                    Scheme scheme = this.issueSecuritySchemeManager.getSchemeFor(issue.getProjectObject());
                                    if (scheme == null) {
                                        throw new IllegalArgumentException("No Issue Security Scheme is applicable to project \"" + issue.getProjectObject().getKey() + "\".");
                                    }
                                    Object var10_60 = null;
                                    for (IssueSecurityLevel securityLevel : levels) {
                                        if (!securityLevel.getSchemeId().equals(scheme.getId())) continue;
                                        Long l = securityLevel.getId();
                                        break;
                                    }
                                    if (var10_62 == null) {
                                        throw new IllegalArgumentException("Security level \"" + value + "\" is not applicable to the current issue.");
                                    }
                                    issue.setSecurityLevelId((Long)var10_62);
                                }
                            }
                            return;
                        } else if (fieldId.equals("assignee")) {
                            ApplicationUser user = (ApplicationUser)this.convertValueToAppUser(value);
                            issue.setAssigneeId(user == null ? null : user.getKey());
                            return;
                        } else if (fieldId.equals("duedate")) {
                            if (value == null) {
                                issue.setDueDate(null);
                            }
                            if (value instanceof Timestamp) {
                                issue.setDueDate((Timestamp)((Object)value));
                                return;
                            } else {
                                if (!(value instanceof String)) return;
                                SimpleDateFormat formatter = new SimpleDateFormat(this.applicationProperties.getDefaultString("jira.date.time.picker.java.format"));
                                try {
                                    Date date = formatter.parse((String)((Object)value));
                                    if (date != null) {
                                        issue.setDueDate(new Timestamp(date.getTime()));
                                        return;
                                    }
                                    issue.setDueDate(null);
                                    return;
                                }
                                catch (ParseException e) {
                                    throw new IllegalArgumentException("Wrong date format exception for \"" + value + "\"");
                                }
                            }
                        } else if (fieldId.equals("reporter")) {
                            ApplicationUser user = (ApplicationUser)this.convertValueToAppUser(value);
                            issue.setReporterId(user == null ? null : user.getKey());
                            return;
                        } else if (fieldId.equals("summary")) {
                            if (value == null || value instanceof String) {
                                issue.setSummary((String)((Object)value));
                                return;
                            } else {
                                issue.setSummary(value.toString());
                            }
                            return;
                        } else if (fieldId.equals("description")) {
                            if (value == null || value instanceof String) {
                                issue.setDescription((String)((Object)value));
                                return;
                            } else {
                                issue.setDescription(value.toString());
                            }
                            return;
                        } else if (fieldId.equals("watches")) {
                            if (value instanceof Collection) {
                                for (Version v : value) {
                                    ApplicationUser u = (ApplicationUser)this.convertValueToAppUser(v);
                                    if (u == null || this.watcherManager.isWatching(u, (Issue)issue)) continue;
                                    this.startWatching(issue, u);
                                }
                                return;
                            } else {
                                ApplicationUser u = (ApplicationUser)this.convertValueToAppUser(value);
                                if (u == null || this.watcherManager.isWatching(u, (Issue)issue)) return;
                                this.startWatching(issue, u);
                            }
                            return;
                        } else if (fieldId.equals("labels")) {
                            if (value == null || value instanceof Set) {
                                issue.setLabels((Set)value);
                                return;
                            } else {
                                if (!(value instanceof Collection)) throw new UnsupportedOperationException("Wrong value type for setting 'Labels'");
                                issue.setLabels(new HashSet<Version>(value));
                            }
                            return;
                        } else if (fieldId.equals("timespent")) {
                            if (value != null && !(value instanceof Long)) throw new UnsupportedOperationException("Wrong value type for setting 'Time Spent' (Long expected)");
                            issue.setTimeSpent((Long)((Object)value));
                            return;
                        } else if (fieldId.equals("timeestimate")) {
                            if (value != null && !(value instanceof Long)) throw new UnsupportedOperationException("Wrong value type for setting 'Time Estimate' (Long expected)");
                            issue.setEstimate((Long)((Object)value));
                            return;
                        } else if (fieldId.equals("timeoriginalestimate")) {
                            if (value != null && !(value instanceof Long)) throw new UnsupportedOperationException("Wrong value type for setting 'Original Estimate' (Long expected)");
                            issue.setOriginalEstimate((Long)((Object)value));
                            return;
                        } else if (fieldId.equals("environment")) {
                            if (value == null || value instanceof String) {
                                issue.setEnvironment((String)((Object)value));
                                return;
                            } else {
                                issue.setEnvironment(value.toString());
                            }
                            return;
                        } else {
                            this.log.error("Issue field \"" + fieldId + "\" is not supported for setting.");
                        }
                    }
                }
            }
        }
    }

    private void startWatching(MutableIssue issue, ApplicationUser u) {
        try {
            Method startWatching = WatcherManager.class.getMethod("startWatching", ApplicationUser.class, Issue.class);
            startWatching.invoke((Object)this.watcherManager, u, issue);
        }
        catch (ReflectiveOperationException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void setIssueComponents(MutableIssue issue, Collection<ProjectComponent> components) {
        try {
            Method setComponentObjects = issue.getClass().getMethod("setComponentObjects", Collection.class);
            setComponentObjects.invoke((Object)issue, components);
        }
        catch (NoSuchMethodException e) {
            try {
                Method setComponents = issue.getClass().getMethod("setComponent", Collection.class);
                setComponents.invoke((Object)issue, components);
            }
            catch (NoSuchMethodException e1) {
                Throwables.propagate((Throwable)e1);
            }
            catch (InvocationTargetException e1) {
                Throwables.propagate((Throwable)e1);
            }
            catch (IllegalAccessException e1) {
                Throwables.propagate((Throwable)e1);
            }
        }
        catch (InvocationTargetException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public String convertToString(Object value) {
        return CONVERTER_STRING.convert(value);
    }

    private Option convertStringToOption(Issue issue, CustomField customField, String value) {
        FieldConfig relevantConfig = customField.getRelevantConfig(issue);
        List<Option> options = this.optionsManager.findByOptionValue(value);
        if (options.size() == 0) {
            try {
                Long optionId = Long.parseLong(value);
                Option option = this.optionsManager.findByOptionId(optionId);
                options = Collections.singletonList(option);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (Option option : options) {
            FieldConfig fieldConfig = option.getRelatedCustomField();
            if (relevantConfig == null || !relevantConfig.equals(fieldConfig)) continue;
            return option;
        }
        throw new IllegalArgumentException("No option found with value '" + value + "' for custom field " + customField.getName() + " on issue " + issue.getKey() + ".");
    }

    private Collection<ProjectComponent> convertValueToComponents(Issue issue, Object value) {
        if (value == null) {
            return Collections.emptySet();
        }
        if (value instanceof GenericValue) {
            return Arrays.asList(this.componentConverter.convertToComponent((GenericValue)value));
        }
        if (value instanceof ProjectComponent) {
            return Arrays.asList((ProjectComponent)value);
        }
        if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                return Collections.emptySet();
            }
            ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>(((Collection)value).size());
            for (Object v : (Collection)value) {
                components.add(this.projectComponentManager.findByComponentName(issue.getProjectObject().getId(), this.convertToString(v)));
            }
            return components;
        }
        ProjectComponent v = this.projectComponentManager.findByComponentName(issue.getProjectObject().getId(), this.convertToString(value));
        if (v != null) {
            return Arrays.asList(v);
        }
        throw new IllegalArgumentException("Wrong component value '" + value + "'.");
    }

    private Collection<Version> convertValueToVersions(Issue issue, Object value) {
        if (value == null) {
            return Collections.emptySet();
        }
        if (value instanceof Version) {
            return Arrays.asList(this.adaptVersionToProject((Version)value, issue.getProjectObject()));
        }
        if (value instanceof Collection) {
            ArrayList<Version> versions = new ArrayList<Version>(((Collection)value).size());
            for (Object v : (Collection)value) {
                versions.add(this.versionManager.getVersion(issue.getProjectObject().getId(), this.convertToString(v)));
            }
            return versions;
        }
        Version v = this.versionManager.getVersion(issue.getProjectObject().getId(), this.convertToString(value));
        if (v != null) {
            return Arrays.asList(v);
        }
        throw new IllegalArgumentException("Wrong version value '" + value + "'.");
    }

    private Version adaptVersionToProject(Version version, Project project) {
        if (version.getProjectObject().equals(project)) {
            return version;
        }
        Version v = this.versionManager.getVersion(project.getId(), version.getName());
        if (v == null) {
            throw new IllegalArgumentException("Version '" + version.getName() + "' does not exist in project '" + project.getName() + "'.");
        }
        return v;
    }

    public Object convertValueToAppUser(Object value) {
        return this.convertValueToAppUser(value, false);
    }

    public Object convertValueToAppUser(Object value, boolean evenIfUnknownAndNotJIRA5) {
        Object user;
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            if (((Collection)value).size() == 0) {
                return null;
            }
            return this.convertValueToAppUser(((Collection)value).iterator().next());
        }
        if (value instanceof User) {
            return UserCompatibilityHelper.getUserObjectApplicableForUserCF((User)value);
        }
        if (this.buildUtilsInfo.getVersionNumbers()[0] < 6) {
            return this.convertValueToUser(value);
        }
        if (UserCompatibilityHelper.isUserObject(value)) {
            return value;
        }
        try {
            Method getUserByKeyMethod = this.userManager.getClass().getMethod("getUserByKey", String.class);
            user = getUserByKeyMethod.invoke((Object)this.userManager, this.convertToString(value).toLowerCase());
            if (user == null) {
                Method getUserByNameMethod = this.userManager.getClass().getMethod("getUserByName", String.class);
                user = getUserByNameMethod.invoke((Object)this.userManager, this.convertToString(value));
            }
            if (user == null && evenIfUnknownAndNotJIRA5) {
                Method getUserByKeyEvenWhenUnknownMethod = this.userManager.getClass().getMethod("getUserByKeyEvenWhenUnknown", String.class);
                user = getUserByKeyEvenWhenUnknownMethod.invoke((Object)this.userManager, this.convertToString(value).toLowerCase());
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (user != null) {
            return user;
        }
        throw new IllegalArgumentException("User '" + value + "' not found.");
    }

    public Object convertValueToAppUsers(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>(((Collection)value).size());
            for (Object obj : (Collection)value) {
                list.add(this.convertValueToAppUser(obj, true));
            }
            return list;
        }
        Object user = this.convertValueToAppUser(value, true);
        if (user != null) {
            return Collections.singletonList(user);
        }
        throw new IllegalArgumentException("User '" + value + "' not found.");
    }

    private User convertValueToUser(Object value) {
        if (value instanceof Collection) {
            value = this.firstValue((Collection)value);
        }
        if (value == null || value instanceof User) {
            return (User)value;
        }
        User user = UserCompatibilityHelper.getUserForKey(this.convertToString(value));
        if (user != null) {
            return user;
        }
        if (this.buildUtilsInfo.getVersionNumbers()[0] >= 6) {
            try {
                Method getUserByNameMethod = this.userManager.getClass().getMethod("getUserByName", String.class);
                user = UserCompatibilityHelper.convertUserObject(getUserByNameMethod.invoke((Object)this.userManager, this.convertToString(value))).getUser();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        if (user != null) {
            return user;
        }
        throw new IllegalArgumentException("User '" + value + "' not found.");
    }

    private Project convertValueToProjectObj(Object value) {
        block9: {
            if (value == null || value instanceof Project) {
                return (Project)value;
            }
            if (value instanceof GenericValue) {
                value = ((GenericValue)value).get("id");
            }
            if (value instanceof Long) {
                Project project = this.projectManager.getProjectObj((Long)value);
                if (project != null) {
                    return project;
                }
            } else {
                String s = this.convertToString(value);
                try {
                    Long id = Long.parseLong(s);
                    Project project = this.projectManager.getProjectObj(id);
                    if (project != null) {
                        return project;
                    }
                }
                catch (NumberFormatException e) {
                    Project project = this.projectManager.getProjectObjByKey(s);
                    if (project == null) {
                        project = this.projectManager.getProjectObjByName(s);
                    }
                    if (project == null) break block9;
                    return project;
                }
            }
        }
        throw new IllegalArgumentException("Wrong project value '" + value + "'.");
    }

    private Project convertValueToProject(Object value) {
        block8: {
            if (value instanceof Project) {
                return (Project)value;
            }
            if (value instanceof Long) {
                Project project = this.projectManager.getProjectObj((Long)value);
                if (project != null) {
                    return project;
                }
            } else {
                String s = this.convertToString(value);
                try {
                    Long id = Long.parseLong(s);
                    Project project = this.projectManager.getProjectObj(id);
                    if (project != null) {
                        return project;
                    }
                }
                catch (NumberFormatException e) {
                    Project project = this.projectManager.getProjectObjByKey(s);
                    if (project == null) {
                        project = this.projectManager.getProjectObjByName(s);
                    }
                    if (project == null) break block8;
                    return project;
                }
            }
        }
        throw new IllegalArgumentException("Wrong project value '" + value + "'.");
    }

    private Map convertOptionToCustomFieldParamsImpl(CustomField customField, Option option) {
        HashMap<String, Option> params = new HashMap<String, Option>();
        Option upperOption = option.getParentOption();
        if (upperOption != null) {
            params.put(CascadingSelectCFType.PARENT_KEY, upperOption);
            params.put("1", option);
        } else {
            params.put(CascadingSelectCFType.PARENT_KEY, option);
        }
        return params;
    }

    private <T> ArrayList<T> asArrayList(T value) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(value);
        return list;
    }

    private Object firstValue(Collection col) {
        int s = col.size();
        if (s == 0) {
            return null;
        }
        if (s > 1) {
            this.log.debug("Got multiple values: " + col.toString() + ". Using only one of them.");
        }
        return col.iterator().next();
    }

    public void setFieldValue(MutableIssue issue, String fieldKey, Object value, IssueChangeHolder changeHolder) {
        Field field = this.getFieldFromKey(fieldKey);
        this.setFieldValue(issue, field, value, changeHolder);
    }

    public List<Group> getGroups(String strGroups, String splitter) {
        String[] groups = strGroups.split("\\Q" + splitter + "\\E");
        ArrayList<Group> groupList = new ArrayList<Group>(groups.length);
        for (String s : groups) {
            Group group = this.crowdService.getGroup(s);
            if (group == null) continue;
            groupList.add(group);
        }
        return groupList;
    }

    public String getStringGroup(Collection<Group> groups, String splitter) {
        StringBuilder sb = new StringBuilder();
        for (Group g : groups) {
            sb.append(g.getName()).append(splitter);
        }
        return sb.toString();
    }

    public List<Field> getFields(String strFields, String splitter) {
        String[] fields = strFields.split("\\Q" + splitter + "\\E");
        ArrayList<Field> fieldList = new ArrayList<Field>(fields.length);
        for (String s : fields) {
            Field field = this.fieldManager.getField(s);
            if (field == null) continue;
            fieldList.add(field);
        }
        return this.fieldCollectionsUtils.sortFields(fieldList);
    }

    public String getStringField(Collection<Field> fields, String splitter) {
        StringBuilder sb = new StringBuilder();
        for (Field f : fields) {
            sb.append(f.getId()).append(splitter);
        }
        return sb.toString();
    }

    public FieldScreen getFieldScreen(ActionDescriptor actionDescriptor) {
        return this.workflowActionsBean.getFieldScreenForView(actionDescriptor);
    }

    public Object convertValue(Field field, Object value, Issue issue) {
        if (value instanceof String[]) {
            return this.stringsToObject(field, (String[])value, issue);
        }
        if (value instanceof ArrayList && ((ArrayList)value).size() > 0 && ((ArrayList)value).get(0) instanceof String) {
            return this.stringsToObject(field, ((ArrayList)value).toArray(new String[0]), issue);
        }
        if (value instanceof String) {
            return this.stringToObject(field, (String)value, issue);
        }
        return value;
    }

    private Object stringsToObject(Field field, String[] value, Issue issue) {
        ArrayList<Object> values = new ArrayList<Object>(value.length);
        for (String v : value) {
            Object o = this.stringToObject(field, v, issue);
            if (o instanceof Collection) {
                values.addAll((Collection)o);
                continue;
            }
            values.add(o);
        }
        return values;
    }

    private Object stringToObject(Field field, String string, Issue issue) {
        boolean wrapInCollection = false;
        if (field instanceof CustomField && ((CustomField)field).getCustomFieldType() instanceof AbstractMultiCFType) {
            Collection strings = MultiSelectCFType.extractTransferObjectFromString((String)string);
            if (strings.size() > 1) {
                return this.stringsToObject(field, strings.toArray(new String[0]), issue);
            }
            wrapInCollection = true;
        }
        if (field instanceof OrderableField) {
            OrderableField orderableField = (OrderableField)field;
            HashMap values = new HashMap();
            if (field instanceof CustomField) {
                try {
                    Object singleObject = ((CustomField)field).getCustomFieldType().getSingularObjectFromString(string);
                    if (singleObject == null) {
                        return string;
                    }
                    if (wrapInCollection) {
                        return Collections.singleton(singleObject);
                    }
                    return singleObject;
                }
                catch (FieldValidationException e) {
                    return string;
                }
            }
            orderableField.populateParamsFromString(values, string, issue);
            return orderableField.getValueFromParams(values);
        }
        return string;
    }

    public <T> Collection<T> getAvailableOptions(Issue issue, String fieldId) {
        Field field = this.getFieldFromKey(fieldId);
        if (field == null) {
            throw new IllegalArgumentException("getAvailableOptions: could not find field '" + fieldId + "'");
        }
        fieldId = field.getId();
        if (this.customFieldManager.isCustomField(fieldId)) {
            CustomField cf = this.customFieldManager.getCustomFieldObject(fieldId);
            CustomFieldType cfType = cf.getCustomFieldType();
            if (cfType instanceof VersionCFType) {
                return this.versionManager.getVersions(issue.getProjectObject());
            }
            if (cfType instanceof ProjectCFType) {
                return this.projectManager.getProjectObjects();
            }
            return this.optionsManager.getOptions(cf.getRelevantConfig(issue));
        }
        if (fieldId.equals("versions") || fieldId.equals("fixVersions")) {
            return this.versionManager.getVersions(issue.getProjectObject());
        }
        if (fieldId.equals("components")) {
            return this.projectComponentManager.findAllForProject(issue.getProjectId());
        }
        if (fieldId.equals("priority")) {
            return this.constantsManager.getPriorityObjects();
        }
        if (fieldId.equals("resolution")) {
            return this.constantsManager.getResolutionObjects();
        }
        if (fieldId.equals("security")) {
            if (this.issueSecuritySchemeManager.getSchemeIdFor(issue.getProjectObject()) != null) {
                return this.issueSecurityLevelManager.getIssueSecurityLevels(this.issueSecuritySchemeManager.getSchemeIdFor(issue.getProjectObject()).longValue());
            }
            return Collections.EMPTY_LIST;
        }
        throw new IllegalArgumentException("Cannot get available options of field " + fieldId);
    }

    public class CascadingSelectValue
    extends HashMap<String, Option> {
        private boolean catenateCascade;

        public CascadingSelectValue(HashMap<String, Option> v, boolean catenateCascade) {
            this.putAll(v);
            this.catenateCascade = catenateCascade;
        }

        @Override
        public String toString() {
            Option parent = (Option)this.get(CascadingSelectCFType.PARENT_KEY);
            Option child = (Option)this.get("1");
            if (parent != null) {
                if (ObjectUtils.isValueSelected((Object)child)) {
                    if (this.catenateCascade) {
                        return parent.toString() + " - " + child.toString();
                    }
                    return child.toString();
                }
                if (this.catenateCascade) {
                    return parent.toString();
                }
                List childOptions = parent.getChildOptions();
                if (childOptions == null || childOptions.isEmpty()) {
                    return parent.toString();
                }
            }
            return null;
        }
    }
}

