/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.util;

import com.atlassian.jira.issue.fields.Field;
import com.opensymphony.workflow.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public class ValidatorErrorsBuilder {
    private List<Field> fields = new ArrayList<Field>();
    private List<String> messages = new ArrayList<String>();
    private boolean forScreen;

    public ValidatorErrorsBuilder(boolean forScreen) {
        this.forScreen = forScreen;
    }

    public void addError(Field field, String message) {
        this.fields.add(field);
        this.messages.add(message);
    }

    public void addError(String message) {
        this.addError(null, message);
    }

    public void process() throws InvalidInputException {
        if (this.fields.size() == 0) {
            return;
        }
        InvalidInputException e = new InvalidInputException();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field f = this.fields.get(i);
            String m = this.messages.get(i);
            if (f == null || !this.forScreen) {
                e.addError(m);
                continue;
            }
            e.addError(f.getId(), m);
        }
        throw e;
    }
}

