/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.helpers.checkers;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.googlecode.jsu.helpers.checkers.ValueConverter;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntity;

public class ConverterString
implements ValueConverter {
    @Override
    public Comparable<?> getComparable(Object object) {
        if (object == null) {
            return null;
        }
        String result = this.convert(object);
        if (StringUtils.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    public String convert(Object value) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        if (value instanceof IssueConstant) {
            return ((IssueConstant)value).getName();
        }
        if (value instanceof Project) {
            return ((Project)value).getKey();
        }
        if (value instanceof Collection && ((Collection)value).size() == 1) {
            return this.convert(((Collection)value).iterator().next());
        }
        if (value instanceof com.atlassian.jira.issue.customfields.option.Option) {
            return ((com.atlassian.jira.issue.customfields.option.Option)value).getValue();
        }
        if (value instanceof Option) {
            return ((Option)value).getName();
        }
        if (UserCompatibilityHelper.isUserObject(value)) {
            return UserCompatibilityHelper.convertUserObject(value).getKey();
        }
        if (value instanceof Group) {
            return ((Group)value).getName();
        }
        if (value instanceof GenericEntity) {
            String s = ((GenericEntity)value).getString("name");
            if (StringUtils.isEmpty((String)s) && StringUtils.isEmpty((String)(s = ((GenericEntity)value).getString("id")))) {
                s = value.toString();
            }
            return s;
        }
        try {
            Method getName = value.getClass().getMethod("getName", new Class[0]);
            return getName.invoke(value, new Object[0]).toString();
        }
        catch (Exception getName) {
            try {
                Method getId = value.getClass().getMethod("getId", new Class[0]);
                return getId.invoke(value, new Object[0]).toString();
            }
            catch (Exception exception) {
                return value.toString();
            }
        }
    }
}

