/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.helpers.checkers;

import com.googlecode.jsu.helpers.checkers.CheckerComposite;
import com.googlecode.jsu.helpers.checkers.ComparingSnipet;
import com.googlecode.jsu.helpers.checkers.ValueConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckerCompositeFactory {
    private static final Logger log = LoggerFactory.getLogger(CheckerCompositeFactory.class);

    public CheckerComposite getComposite(String converterClass, String snipetClass) {
        ComparingSnipet snipet = (ComparingSnipet)this.getInstance(snipetClass);
        if (snipet == null) {
            return null;
        }
        ValueConverter converter = (ValueConverter)this.getInstance(converterClass);
        if (converter == null) {
            return null;
        }
        return new CheckerComposite(converter, snipet);
    }

    private <T> T getInstance(String className) {
        T instance = null;
        try {
            instance = (T)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            log.error("Unable to initialize class [" + className + "]", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("Unable to initialize class [" + className + "]", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to initialize class [" + className + "]", (Throwable)e);
        }
        return instance;
    }
}

