/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.helpers.checkers;

import com.googlecode.jsu.helpers.ConditionChecker;
import com.googlecode.jsu.helpers.checkers.ComparingSnipet;
import com.googlecode.jsu.helpers.checkers.ValueConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CheckerComposite
implements ConditionChecker {
    private final Logger log = LoggerFactory.getLogger(CheckerComposite.class);
    private final ValueConverter valueConverter;
    private final ComparingSnipet comparingSnipet;

    public CheckerComposite(ValueConverter valueConverter, ComparingSnipet comparingSnipet) {
        this.valueConverter = valueConverter;
        this.comparingSnipet = comparingSnipet;
    }

    @Override
    public final boolean checkValues(Object value1, Object value2) {
        Comparable<?> comp2;
        Comparable<Comparable<?>> comp1;
        try {
            comp1 = this.valueConverter.getComparable(value1);
        }
        catch (NumberFormatException e) {
            this.log.warn("Wrong number format at [" + value1 + "]");
            return false;
        }
        catch (Exception e) {
            this.log.warn("Unable to get comparable from [" + value1 + "]", (Throwable)e);
            return false;
        }
        try {
            comp2 = this.valueConverter.getComparable(value2);
        }
        catch (NumberFormatException e) {
            this.log.warn("Wrong number format at [" + value2 + "]");
            return false;
        }
        catch (Exception e) {
            this.log.warn("Unable to get comparable from [" + value2 + "]", (Throwable)e);
            return false;
        }
        boolean result = this.comparingSnipet.compareObjects(comp1, comp2);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compare values [" + comp1 + "] and [" + comp2 + "] with result [" + result + "]");
        }
        return result;
    }
}

