/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.helpers;

import com.googlecode.jsu.helpers.ComparisonType;
import com.googlecode.jsu.helpers.ConditionChecker;
import com.googlecode.jsu.helpers.ConditionType;
import com.googlecode.jsu.helpers.checkers.CheckerCompositeFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionCheckerFactory {
    public static final ConditionType GREATER = new ConditionType(1, ">", "greater than", "G");
    public static final ConditionType GREATER_EQUAL = new ConditionType(2, ">=", "greater than or equal to", "GE");
    public static final ConditionType EQUAL = new ConditionType(3, "=", "equal to", "E");
    public static final ConditionType LESS_EQUAL = new ConditionType(4, "<=", "less than or equal to", "LE");
    public static final ConditionType LESS = new ConditionType(5, "<", "less than", "L");
    public static final ConditionType NOT_EQUAL = new ConditionType(6, "!=", "not equal to", "NE");
    public static final ComparisonType STRING = new ComparisonType(1, "String", "String");
    public static final ComparisonType NUMBER = new ComparisonType(2, "Number", "Number");
    public static final ComparisonType DATE = new ComparisonType(3, "Date with time", "Date");
    public static final ComparisonType DATE_WITHOUT_TIME = new ComparisonType(4, "Date without time", "DateWithoutTime");
    private static final String PACKAGE = ConditionCheckerFactory.class.getPackage().getName();
    private static final String CONDITION_CLASS_TEMPLATE = PACKAGE + ".checkers.Snipet";
    private static final String COMPARISON_CLASS_TEMPLATE = PACKAGE + ".checkers.Converter";
    private static final Map<Integer, ConditionType> CONDITIONS_CACHE = new LinkedHashMap<Integer, ConditionType>(6){
        {
            this.put(GREATER.getId(), GREATER);
            this.put(GREATER_EQUAL.getId(), GREATER_EQUAL);
            this.put(EQUAL.getId(), EQUAL);
            this.put(LESS_EQUAL.getId(), LESS_EQUAL);
            this.put(LESS.getId(), LESS);
            this.put(NOT_EQUAL.getId(), NOT_EQUAL);
        }
    };
    private static final Map<Integer, ComparisonType> COMPARISONS_CACHE = new LinkedHashMap<Integer, ComparisonType>(4){
        {
            this.put(STRING.getId(), STRING);
            this.put(NUMBER.getId(), NUMBER);
            this.put(DATE.getId(), DATE);
            this.put(DATE_WITHOUT_TIME.getId(), DATE_WITHOUT_TIME);
        }
    };
    private final Logger log = LoggerFactory.getLogger(ConditionCheckerFactory.class);
    private final CheckerCompositeFactory checkerCompositeFactory = new CheckerCompositeFactory();

    public ConditionChecker getChecker(ComparisonType type, ConditionType condition) {
        String conditionClassName = CONDITION_CLASS_TEMPLATE + condition.getMnemonic();
        String comparisonClassName = COMPARISON_CLASS_TEMPLATE + type.getMnemonic();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using class [" + conditionClassName + "] for condition [" + condition.getValue() + "]; class [" + comparisonClassName + "] for type [" + type.getValue() + "]");
        }
        return this.checkerCompositeFactory.getComposite(comparisonClassName, conditionClassName);
    }

    public List<ConditionType> getConditionTypes() {
        return new ArrayList<ConditionType>(CONDITIONS_CACHE.values());
    }

    public List<ComparisonType> getComparisonTypes() {
        ArrayList<ComparisonType> comparisonTypes = new ArrayList<ComparisonType>(COMPARISONS_CACHE.values());
        comparisonTypes.remove(DATE);
        comparisonTypes.remove(DATE_WITHOUT_TIME);
        return comparisonTypes;
    }

    public ConditionType findConditionById(String id) {
        return CONDITIONS_CACHE.get(Integer.valueOf(id));
    }

    public ComparisonType findComparisonById(String id) {
        return COMPARISONS_CACHE.get(Integer.valueOf(id));
    }
}

