/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsu.annotation;

import com.googlecode.jsu.annotation.AbstractVisitor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class AnnotationProcessor {
    private List<AbstractVisitor> visitors = new ArrayList<AbstractVisitor>();

    public void addVisitor(AbstractVisitor visitor) {
        this.visitors.add(visitor);
    }

    public void processAnnotations(Object object) {
        Class<?> clazz = object.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            for (AbstractVisitor visitor : this.visitors) {
                Annotation a = field.getAnnotation(visitor.getAnnotation());
                if (a == null) continue;
                visitor.visitField(object, field, a);
            }
        }
    }
}

