/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.storage.lib;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.osgi.Version;
import com.atlassian.upm.osgi.impl.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionChecker {
    private static final Logger log = LoggerFactory.getLogger(VersionChecker.class);

    private VersionChecker() {
    }

    static boolean isUpm201OrLaterInstalled(PluginAccessor pluginAccessor) {
        return VersionChecker.isUpmVersionEqualToOrAfter("2.0.1", pluginAccessor);
    }

    static boolean isUpm28OrLaterInstalled(PluginAccessor pluginAccessor) {
        return VersionChecker.isUpmVersionEqualToOrAfter("2.8", pluginAccessor);
    }

    private static boolean isUpmVersionEqualToOrAfter(String version, PluginAccessor pluginAccessor) {
        Plugin plugin = pluginAccessor.getPlugin("com.atlassian.upm.atlassian-universal-plugin-manager-plugin");
        if (plugin == null) {
            return false;
        }
        try {
            Version upmVersion = Versions.fromPlugin(plugin, false);
            Version requiredVersion = Versions.fromString(version, false);
            return requiredVersion.compareTo(upmVersion) <= 0;
        }
        catch (Exception e) {
            log.debug("Error while detecting UPM version", (Throwable)e);
            return false;
        }
    }
}

